package com.finconsgroup.itserr.marketplace.metrics.dm.mapper;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputBeneficiaryDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputBeneficiaryDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventBeneficiaryEntity;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

import java.util.Collection;
import java.util.List;
import java.util.UUID;

/**
 * Mapper interface responsible for converting between metric events beneficiaries.
 */
@Mapper(config = MapperConfiguration.class)
public interface BeneficiaryMapper {

    /**
     * Converts an {@link InputBeneficiaryDto} into a {@link MetricEventBeneficiaryEntity}.
     *
     * @param src the input DTO containing beneficiary data
     * @param metric the type of metric corresponding to the event
     * @param eventId the unique identifier of the metric event
     * @return a {@link MetricEventBeneficiaryEntity} representing the metric event beneficiary
     */
    @Mapping(target = "userRef", source = "src.user")
    MetricEventBeneficiaryEntity toEntity(
            InputBeneficiaryDto src,
            MetricDtoType metric,
            UUID eventId);

    /**
     * Converts a {@link MetricEventBeneficiaryEntity} into an {@link OutputBeneficiaryDto}.
     *
     * @param src the source entity containing metric event beneficiary data
     * @return an {@link OutputBeneficiaryDto} representing the metric event beneficiary
     */
    @Named("beneficiaryToDto")
    @Mapping(target = "user", source = "userRef")
    OutputBeneficiaryDto toDto(MetricEventBeneficiaryEntity src);

    /**
     * Converts a collection of {@link MetricEventBeneficiaryEntity} instances into a list of {@link OutputBeneficiaryDto}.
     *
     * @param beneficiaries the collection of {@link MetricEventBeneficiaryEntity} instances to be converted
     * @return a list of {@link OutputBeneficiaryDto} representing the converted beneficiaries
     */
    @Named("beneficiariesToDtoList")
    @IterableMapping(qualifiedByName = "beneficiaryToDto")
    List<OutputBeneficiaryDto> toDtoList(Collection<MetricEventBeneficiaryEntity> beneficiaries);

}
