package com.finconsgroup.itserr.marketplace.metrics.dm.openapi;

import io.swagger.v3.oas.models.servers.Server;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * Configuration class for customizing OpenAPI documentation settings. This class provides beans and configuration for Swagger/OpenAPI documentation,
 * particularly focusing on server URL configuration.
 */
@Configuration
public class OpenApiConfiguration {

    /** The URL for the Swagger API server, configured via properties */
    @Value("${metrics.dm.swagger-api-server-url}")
    private String swaggerApiServer;

    /**
     * Creates an {@link OpenApiCustomizer} bean that configures the server URL for the API documentation.
     *
     * @return {@link OpenApiCustomizer} instance that sets the server URL using the configured swaggerApiServer value
     */
    @Bean
    public OpenApiCustomizer customServerOpenApiCustomizer() {
        return openApi -> openApi
                .setServers(List.of(new Server().url(swaggerApiServer)));
    }

}
