/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.bs;

import com.finconsgroup.itserr.marketplace.metrics.dm.config.properties.HibernateConfigurationProperties;
import com.finconsgroup.itserr.marketplace.metrics.dm.exception.UpdateMetricsException;
import java.time.LocalDateTime;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class MVUpdater {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MVUpdater.class);
    private static final String MV_EVENT_DAILY_COUNTS_NAME = "metric_event_daily_counts";
    private static final String MV_BENEFICIARY_EVENT_DAILY_COUNTS_NAME = "beneficiary_metric_event_daily_counts";
    private static final String MV_BENEFICIARY_METRIC_INTEREST_NAME = "beneficiary_metric_interest";
    private static final String MV_BENEFICIARY_INTEREST_NAME = "beneficiary_interest";
    private final JdbcTemplate jdbc;
    private final HibernateConfigurationProperties config;
    private LocalDateTime lastUpdate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        log.debug("Updating materialized views");
        MVUpdater mVUpdater = this;
        synchronized (mVUpdater) {
            LocalDateTime updateStartTime = LocalDateTime.now();
            String schemaPrefix = Optional.ofNullable(this.config.getDefaultSchema()).filter(StringUtils::isNotBlank).map(d -> "\"" + d + "\".").orElse("");
            this.updateMV(schemaPrefix, MV_EVENT_DAILY_COUNTS_NAME);
            this.updateMV(schemaPrefix, MV_BENEFICIARY_EVENT_DAILY_COUNTS_NAME);
            this.updateMV(schemaPrefix, MV_BENEFICIARY_METRIC_INTEREST_NAME);
            this.updateMV(schemaPrefix, MV_BENEFICIARY_INTEREST_NAME);
            this.lastUpdate = updateStartTime;
        }
        log.debug("Materialized views update completed");
    }

    private void updateMV(String schemaPrefix, String mvName) {
        log.debug("Updating materialized view {}", (Object)mvName);
        try {
            this.jdbc.execute("REFRESH MATERIALIZED VIEW CONCURRENTLY " + schemaPrefix + "\"" + mvName + "\"");
        }
        catch (Exception e) {
            throw new UpdateMetricsException("Error updating materialized view: " + mvName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateIfElderThan(LocalDateTime time) {
        LocalDateTime localLastUpdate;
        MVUpdater mVUpdater = this;
        synchronized (mVUpdater) {
            localLastUpdate = this.lastUpdate;
        }
        if (localLastUpdate == null || localLastUpdate.isBefore(time)) {
            this.update();
            return true;
        }
        log.debug("Materialized view {} update aborted (already updated)", (Object)MV_EVENT_DAILY_COUNTS_NAME);
        return false;
    }

    @Generated
    public MVUpdater(JdbcTemplate jdbc, HibernateConfigurationProperties config) {
        this.jdbc = jdbc;
        this.config = config;
    }

    @Generated
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }
}

