package com.finconsgroup.itserr.marketplace.search.bs.component;

import com.finconsgroup.itserr.messaging.autoconfigure.MessagingProperties;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Optional;

@Component
@RequiredArgsConstructor
@Slf4j
public class StartupShutdownEventListener {

    private final Optional<MessagingProperties> messagingPropertiesOptional;

    @EventListener
    void onStartup(ApplicationReadyEvent event) {

        if (messagingPropertiesOptional.isPresent()) {
            messagingPropertiesOptional.get().clients()
                    .stream().flatMap(c ->
                            Optional.ofNullable(c.streams()).orElse(List.of()).stream()
                    ).forEach(c -> log.info("Enabled consumer for stream - {} : {}", c.name(),
                            c.consumer().enabled()));
        } else {
            log.info("Messaging is disabled, so no consumer is enabled");
        }
    }
}
