package com.finconsgroup.itserr.marketplace.search.bs.messaging;

import com.finconsgroup.itserr.marketplace.search.bs.client.dm.SearchDmClient;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.MessagingEventBsProperties;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.SearchBsConfigurationProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Component("eventResourceSubscriber")
@Slf4j
public class EventResourceSubscriber extends AbstractResourceSubscriber {

    /**
     * Messaging configuration properties for event-bs events.
     */
    private final MessagingEventBsProperties messagingEventBsProperties;

    /**
     * The client used to interact with the search dm.
     */
    private final SearchDmClient searchDmClient;

    /**
     * Constructs the EventResourceSubscriber
     *
     * @param searchBsConfigurationProperties the application configuration properties
     * @param searchDmClient                  http client for interacting with the search DM service
     */
    public EventResourceSubscriber(
            SearchBsConfigurationProperties searchBsConfigurationProperties,
            SearchDmClient searchDmClient
    ) {
        this.messagingEventBsProperties = searchBsConfigurationProperties.getMessaging().getEventBs();
        this.searchDmClient = searchDmClient;
    }

    @Override
    protected void handleResource(String resourceId, Object resourcePayload, String eventType) {
        log.debug("Processing event bs event, id: {}, payload: {}, type: {}", resourceId, resourcePayload, eventType);
        if (Objects.equals(eventType, messagingEventBsProperties.getResourceCreatedEventType()) ||
                Objects.equals(eventType, messagingEventBsProperties.getResourceUpdatedEventType())) {
            searchDmClient.upsertEvent(resourceId, resourcePayload);
        } else if (Objects.equals(eventType, messagingEventBsProperties.getResourceDeletedEventType())) {
            searchDmClient.deleteEvent(resourceId);
        } else {
            log.error("Unsupported eventType: {} for resourceId: {}", eventType, resourceId);
        }
    }
}
