package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;


/**
 * It represents the payload for catalog item institutional page.
 */
@Schema(name = "CatalogInstitutionalPageDto",
        description = "Represents the payload for catalog item institutional page")
@Data
@Builder
@AllArgsConstructor
public class CatalogInstitutionalPageDto {

    @Schema(description = "ID of the institutional page", example = "11111111-bbbb-0000-0000-000000000000")
    private String id;

    @Schema(description = "The name of the institutional page", example = "Criterion")
    private String name;

    @Schema(
            description = "The abstract of the institutional page",
            example = "WP3, the Toolkit for Religious Studies (T-ReS), aims to improve the research experience."
    )
    private String abstractContent;

    @Schema(description = "The category of the institutional page", example = "project")
    private String category;

}
