package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;

/**
 * It represents the payload for catalog item type.
 */
@Schema(name = "CatalogTypeDto",
        description = "Represents the payload for catalog item type")
@Data
@Builder
@AllArgsConstructor
public class CatalogTypeDto {

    /**
     * The unique identifier for this catalog type.
     */
    private String id;

    /**
     * The name of this catalog type
     */
    private String name;

    /**
     * A detailed description of what this catalog type represents.
     */
    private String description;

    /**
     * The identifier of the associated metadata (e.g., the column ID in metadata table).
     */
    private String metadataId;

    /**
     * A value representing when the entity was created.
     */
    private Instant createTs;

    /**
     * A value representing the last time the entity was updated.
     */
    private Instant updateTs;
    /**
     * A flag representing if the entity has been deleted or not.
     */
    private Boolean deleteTs;

}