package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import com.finconsgroup.itserr.marketplace.search.dm.dto.AuthorDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.CatalogInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.CatalogManualReferenceDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.CatalogMetadataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.CatalogMetadataSetDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.CatalogParagraphDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.CatalogPublicationDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.CatalogReferencesDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.CatalogResourceDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.CatalogTypeDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputCatalogDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogFavouriteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Author;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Catalog;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-12-29T14:36:59+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class CatalogMapperImpl implements CatalogMapper {

    @Override
    public Catalog toEntity(InputCatalogDto dto) {
        if ( dto == null ) {
            return null;
        }

        Catalog.CatalogBuilder catalog = Catalog.builder();

        catalog.id( dto.getId() );
        catalog.status( dto.getStatus() );
        catalog.moderationMessage( dto.getModerationMessage() );
        catalog.createdBy( dto.getCreatedBy() );
        catalog.createdAt( dto.getCreatedAt() );
        catalog.updatedBy( dto.getUpdatedBy() );
        catalog.updatedAt( dto.getUpdatedAt() );
        catalog.title( dto.getTitle() );
        catalog.description( dto.getDescription() );
        catalog.imageUrl( dto.getImageUrl() );
        catalog.paragraphs( catalogParagraphDtoListToParagraphList( dto.getParagraphs() ) );
        catalog.doi( dto.getDoi() );
        catalog.license( dto.getLicense() );
        catalog.institutionalPag( catalogInstitutionalPageDtoToInstitutionalPage( dto.getInstitutionalPag() ) );
        catalog.authors( authorDtoListToAuthorList( dto.getAuthors() ) );
        catalog.maintainer( authorDtoToAuthor( dto.getMaintainer() ) );
        List<String> list2 = dto.getTags();
        if ( list2 != null ) {
            catalog.tags( new ArrayList<String>( list2 ) );
        }
        catalog.language( dto.getLanguage() );
        catalog.type( catalogTypeDtoToCatalogType( dto.getType() ) );
        catalog.metadataSet( catalogMetadataSetDtoToMetadataSet( dto.getMetadataSet() ) );
        catalog.references( catalogReferencesDtoToReferences( dto.getReferences() ) );
        catalog.metadata( catalogMetadataDtoListToMetadataList( dto.getMetadata() ) );
        catalog.publication( catalogPublicationDtoToPublication( dto.getPublication() ) );
        catalog.resources( catalogResourceDtoListToResourceList( dto.getResources() ) );

        return catalog.build();
    }

    @Override
    public OutputCatalogDto toDto(Catalog entity) {
        if ( entity == null ) {
            return null;
        }

        OutputCatalogDto.OutputCatalogDtoBuilder outputCatalogDto = OutputCatalogDto.builder();

        outputCatalogDto.id( entity.getId() );
        outputCatalogDto.status( entity.getStatus() );
        outputCatalogDto.moderationMessage( entity.getModerationMessage() );
        outputCatalogDto.createdBy( entity.getCreatedBy() );
        outputCatalogDto.createdAt( entity.getCreatedAt() );
        outputCatalogDto.updatedBy( entity.getUpdatedBy() );
        outputCatalogDto.updatedAt( entity.getUpdatedAt() );
        outputCatalogDto.title( entity.getTitle() );
        outputCatalogDto.description( entity.getDescription() );
        outputCatalogDto.imageUrl( entity.getImageUrl() );
        outputCatalogDto.paragraphs( paragraphListToCatalogParagraphDtoList( entity.getParagraphs() ) );
        outputCatalogDto.doi( entity.getDoi() );
        outputCatalogDto.license( entity.getLicense() );
        outputCatalogDto.institutionalPag( institutionalPageToCatalogInstitutionalPageDto( entity.getInstitutionalPag() ) );
        outputCatalogDto.authors( authorListToAuthorDtoList( entity.getAuthors() ) );
        outputCatalogDto.maintainer( authorToAuthorDto( entity.getMaintainer() ) );
        List<String> list2 = entity.getTags();
        if ( list2 != null ) {
            outputCatalogDto.tags( new ArrayList<String>( list2 ) );
        }
        outputCatalogDto.language( entity.getLanguage() );
        outputCatalogDto.type( catalogTypeToCatalogTypeDto( entity.getType() ) );
        outputCatalogDto.metadataSet( metadataSetToCatalogMetadataSetDto( entity.getMetadataSet() ) );
        outputCatalogDto.references( referencesToCatalogReferencesDto( entity.getReferences() ) );
        outputCatalogDto.metadata( metadataListToCatalogMetadataDtoList( entity.getMetadata() ) );
        outputCatalogDto.publication( publicationToCatalogPublicationDto( entity.getPublication() ) );
        outputCatalogDto.resources( resourceListToCatalogResourceDtoList( entity.getResources() ) );

        return outputCatalogDto.build();
    }

    @Override
    public OutputGlobalSearchAutoCompleteDataDto toAutoCompleteDataDto(Catalog entity) {
        if ( entity == null ) {
            return null;
        }

        OutputGlobalSearchAutoCompleteDataDto.OutputGlobalSearchAutoCompleteDataDtoBuilder outputGlobalSearchAutoCompleteDataDto = OutputGlobalSearchAutoCompleteDataDto.builder();

        outputGlobalSearchAutoCompleteDataDto.id( entity.getId() );
        outputGlobalSearchAutoCompleteDataDto.title( entity.getTitle() );
        outputGlobalSearchAutoCompleteDataDto.score( entity.getScore() );

        return outputGlobalSearchAutoCompleteDataDto.build();
    }

    @Override
    public OutputCatalogLocalSearchDto toLocalSearchDto(Catalog entity) {
        if ( entity == null ) {
            return null;
        }

        OutputCatalogLocalSearchDto.OutputCatalogLocalSearchDtoBuilder outputCatalogLocalSearchDto = OutputCatalogLocalSearchDto.builder();

        outputCatalogLocalSearchDto.id( entity.getId() );
        outputCatalogLocalSearchDto.title( entity.getTitle() );
        List<String> list = entity.getTags();
        if ( list != null ) {
            outputCatalogLocalSearchDto.tags( new ArrayList<String>( list ) );
        }
        outputCatalogLocalSearchDto.authors( authorListToAuthorDtoList( entity.getAuthors() ) );
        outputCatalogLocalSearchDto.createdAt( entity.getCreatedAt() );
        outputCatalogLocalSearchDto.description( entity.getDescription() );
        outputCatalogLocalSearchDto.type( catalogTypeToCatalogTypeDto( entity.getType() ) );
        outputCatalogLocalSearchDto.imageUrl( entity.getImageUrl() );
        outputCatalogLocalSearchDto.maintainer( authorToAuthorDto( entity.getMaintainer() ) );

        return outputCatalogLocalSearchDto.build();
    }

    @Override
    public OutputCatalogFavouriteDto toFavouriteDto(Catalog entity) {
        if ( entity == null ) {
            return null;
        }

        OutputCatalogFavouriteDto.OutputCatalogFavouriteDtoBuilder<?, ?> outputCatalogFavouriteDto = OutputCatalogFavouriteDto.builder();

        outputCatalogFavouriteDto.publicationDate( entityPublicationDate( entity ) );
        outputCatalogFavouriteDto.id( entity.getId() );
        outputCatalogFavouriteDto.title( entity.getTitle() );
        List<String> list = entity.getTags();
        if ( list != null ) {
            outputCatalogFavouriteDto.tags( new ArrayList<String>( list ) );
        }
        outputCatalogFavouriteDto.authors( authorListToAuthorDtoList( entity.getAuthors() ) );
        outputCatalogFavouriteDto.language( entity.getLanguage() );
        outputCatalogFavouriteDto.createdAt( entity.getCreatedAt() );
        outputCatalogFavouriteDto.description( entity.getDescription() );
        outputCatalogFavouriteDto.type( catalogTypeToCatalogTypeDto( entity.getType() ) );
        outputCatalogFavouriteDto.imageUrl( entity.getImageUrl() );
        outputCatalogFavouriteDto.maintainer( authorToAuthorDto( entity.getMaintainer() ) );
        outputCatalogFavouriteDto.doi( entity.getDoi() );

        return outputCatalogFavouriteDto.build();
    }

    @Override
    public OutputGlobalSearchDataDto toGlobalSearchDataDto(Catalog entity) {
        if ( entity == null ) {
            return null;
        }

        OutputGlobalSearchDataDto.OutputGlobalSearchDataDtoBuilder outputGlobalSearchDataDto = OutputGlobalSearchDataDto.builder();

        outputGlobalSearchDataDto.id( entity.getId() );
        outputGlobalSearchDataDto.title( entity.getTitle() );
        outputGlobalSearchDataDto.description( entity.getDescription() );
        outputGlobalSearchDataDto.imageUrl( entity.getImageUrl() );
        outputGlobalSearchDataDto.score( entity.getScore() );

        return outputGlobalSearchDataDto.build();
    }

    protected Catalog.Paragraph catalogParagraphDtoToParagraph(CatalogParagraphDto catalogParagraphDto) {
        if ( catalogParagraphDto == null ) {
            return null;
        }

        Catalog.Paragraph.ParagraphBuilder paragraph = Catalog.Paragraph.builder();

        paragraph.id( catalogParagraphDto.getId() );
        paragraph.title( catalogParagraphDto.getTitle() );
        paragraph.content( catalogParagraphDto.getContent() );
        paragraph.imageUrl( catalogParagraphDto.getImageUrl() );
        paragraph.resourceUrl( catalogParagraphDto.getResourceUrl() );
        List<String> list = catalogParagraphDto.getLabels();
        if ( list != null ) {
            paragraph.labels( new ArrayList<String>( list ) );
        }

        return paragraph.build();
    }

    protected List<Catalog.Paragraph> catalogParagraphDtoListToParagraphList(List<CatalogParagraphDto> list) {
        if ( list == null ) {
            return null;
        }

        List<Catalog.Paragraph> list1 = new ArrayList<Catalog.Paragraph>( list.size() );
        for ( CatalogParagraphDto catalogParagraphDto : list ) {
            list1.add( catalogParagraphDtoToParagraph( catalogParagraphDto ) );
        }

        return list1;
    }

    protected Catalog.InstitutionalPage catalogInstitutionalPageDtoToInstitutionalPage(CatalogInstitutionalPageDto catalogInstitutionalPageDto) {
        if ( catalogInstitutionalPageDto == null ) {
            return null;
        }

        Catalog.InstitutionalPage.InstitutionalPageBuilder institutionalPage = Catalog.InstitutionalPage.builder();

        institutionalPage.id( catalogInstitutionalPageDto.getId() );
        institutionalPage.name( catalogInstitutionalPageDto.getName() );
        institutionalPage.abstractContent( catalogInstitutionalPageDto.getAbstractContent() );
        institutionalPage.category( catalogInstitutionalPageDto.getCategory() );

        return institutionalPage.build();
    }

    protected Author authorDtoToAuthor(AuthorDto authorDto) {
        if ( authorDto == null ) {
            return null;
        }

        Author.AuthorBuilder author = Author.builder();

        author.id( authorDto.getId() );
        author.firstName( authorDto.getFirstName() );
        author.lastName( authorDto.getLastName() );
        author.email( authorDto.getEmail() );
        author.orcid( authorDto.getOrcid() );

        return author.build();
    }

    protected List<Author> authorDtoListToAuthorList(List<AuthorDto> list) {
        if ( list == null ) {
            return null;
        }

        List<Author> list1 = new ArrayList<Author>( list.size() );
        for ( AuthorDto authorDto : list ) {
            list1.add( authorDtoToAuthor( authorDto ) );
        }

        return list1;
    }

    protected Catalog.CatalogType catalogTypeDtoToCatalogType(CatalogTypeDto catalogTypeDto) {
        if ( catalogTypeDto == null ) {
            return null;
        }

        Catalog.CatalogType.CatalogTypeBuilder catalogType = Catalog.CatalogType.builder();

        catalogType.id( catalogTypeDto.getId() );
        catalogType.name( catalogTypeDto.getName() );
        catalogType.description( catalogTypeDto.getDescription() );
        catalogType.metadataId( catalogTypeDto.getMetadataId() );
        catalogType.createTs( catalogTypeDto.getCreateTs() );
        catalogType.updateTs( catalogTypeDto.getUpdateTs() );
        catalogType.deleteTs( catalogTypeDto.getDeleteTs() );

        return catalogType.build();
    }

    protected Catalog.MetadataSet catalogMetadataSetDtoToMetadataSet(CatalogMetadataSetDto catalogMetadataSetDto) {
        if ( catalogMetadataSetDto == null ) {
            return null;
        }

        Catalog.MetadataSet.MetadataSetBuilder metadataSet = Catalog.MetadataSet.builder();

        metadataSet.id( catalogMetadataSetDto.getId() );
        metadataSet.name( catalogMetadataSetDto.getName() );
        metadataSet.description( catalogMetadataSetDto.getDescription() );
        metadataSet.standard( catalogMetadataSetDto.isStandard() );

        return metadataSet.build();
    }

    protected Catalog.Publication catalogPublicationDtoToPublication(CatalogPublicationDto catalogPublicationDto) {
        if ( catalogPublicationDto == null ) {
            return null;
        }

        Catalog.Publication.PublicationBuilder publication = Catalog.Publication.builder();

        publication.date( catalogPublicationDto.getDate() );
        publication.zipCode( catalogPublicationDto.getZipCode() );
        publication.city( catalogPublicationDto.getCity() );
        publication.region( catalogPublicationDto.getRegion() );
        publication.country( catalogPublicationDto.getCountry() );

        return publication.build();
    }

    protected Catalog.ManualReference catalogManualReferenceDtoToManualReference(CatalogManualReferenceDto catalogManualReferenceDto) {
        if ( catalogManualReferenceDto == null ) {
            return null;
        }

        Catalog.ManualReference.ManualReferenceBuilder manualReference = Catalog.ManualReference.builder();

        manualReference.title( catalogManualReferenceDto.getTitle() );
        manualReference.url( catalogManualReferenceDto.getUrl() );
        manualReference.authors( authorDtoListToAuthorList( catalogManualReferenceDto.getAuthors() ) );
        manualReference.volume( catalogManualReferenceDto.getVolume() );
        manualReference.paragraph( catalogManualReferenceDto.getParagraph() );
        manualReference.pages( catalogManualReferenceDto.getPages() );
        manualReference.publication( catalogPublicationDtoToPublication( catalogManualReferenceDto.getPublication() ) );

        return manualReference.build();
    }

    protected List<Catalog.ManualReference> catalogManualReferenceDtoListToManualReferenceList(List<CatalogManualReferenceDto> list) {
        if ( list == null ) {
            return null;
        }

        List<Catalog.ManualReference> list1 = new ArrayList<Catalog.ManualReference>( list.size() );
        for ( CatalogManualReferenceDto catalogManualReferenceDto : list ) {
            list1.add( catalogManualReferenceDtoToManualReference( catalogManualReferenceDto ) );
        }

        return list1;
    }

    protected Catalog.References catalogReferencesDtoToReferences(CatalogReferencesDto catalogReferencesDto) {
        if ( catalogReferencesDto == null ) {
            return null;
        }

        Catalog.References.ReferencesBuilder references = Catalog.References.builder();

        List<String> list = catalogReferencesDto.getDois();
        if ( list != null ) {
            references.dois( new ArrayList<String>( list ) );
        }
        references.manualReferences( catalogManualReferenceDtoListToManualReferenceList( catalogReferencesDto.getManualReferences() ) );

        return references.build();
    }

    protected Catalog.Metadata catalogMetadataDtoToMetadata(CatalogMetadataDto catalogMetadataDto) {
        if ( catalogMetadataDto == null ) {
            return null;
        }

        Catalog.Metadata.MetadataBuilder metadata = Catalog.Metadata.builder();

        metadata.key( catalogMetadataDto.getKey() );
        metadata.value( catalogMetadataDto.getValue() );

        return metadata.build();
    }

    protected List<Catalog.Metadata> catalogMetadataDtoListToMetadataList(List<CatalogMetadataDto> list) {
        if ( list == null ) {
            return null;
        }

        List<Catalog.Metadata> list1 = new ArrayList<Catalog.Metadata>( list.size() );
        for ( CatalogMetadataDto catalogMetadataDto : list ) {
            list1.add( catalogMetadataDtoToMetadata( catalogMetadataDto ) );
        }

        return list1;
    }

    protected Catalog.Resource catalogResourceDtoToResource(CatalogResourceDto catalogResourceDto) {
        if ( catalogResourceDto == null ) {
            return null;
        }

        Catalog.Resource.ResourceBuilder resource = Catalog.Resource.builder();

        resource.name( catalogResourceDto.getName() );
        resource.description( catalogResourceDto.getDescription() );
        resource.url( catalogResourceDto.getUrl() );
        resource.type( catalogResourceDto.getType() );
        resource.mimeType( catalogResourceDto.getMimeType() );
        resource.createdBy( catalogResourceDto.getCreatedBy() );
        resource.createdAt( catalogResourceDto.getCreatedAt() );
        resource.updatedBy( catalogResourceDto.getUpdatedBy() );
        resource.updatedAt( catalogResourceDto.getUpdatedAt() );

        return resource.build();
    }

    protected List<Catalog.Resource> catalogResourceDtoListToResourceList(List<CatalogResourceDto> list) {
        if ( list == null ) {
            return null;
        }

        List<Catalog.Resource> list1 = new ArrayList<Catalog.Resource>( list.size() );
        for ( CatalogResourceDto catalogResourceDto : list ) {
            list1.add( catalogResourceDtoToResource( catalogResourceDto ) );
        }

        return list1;
    }

    protected CatalogParagraphDto paragraphToCatalogParagraphDto(Catalog.Paragraph paragraph) {
        if ( paragraph == null ) {
            return null;
        }

        CatalogParagraphDto.CatalogParagraphDtoBuilder catalogParagraphDto = CatalogParagraphDto.builder();

        catalogParagraphDto.id( paragraph.getId() );
        catalogParagraphDto.title( paragraph.getTitle() );
        catalogParagraphDto.content( paragraph.getContent() );
        catalogParagraphDto.imageUrl( paragraph.getImageUrl() );
        catalogParagraphDto.resourceUrl( paragraph.getResourceUrl() );
        List<String> list = paragraph.getLabels();
        if ( list != null ) {
            catalogParagraphDto.labels( new ArrayList<String>( list ) );
        }

        return catalogParagraphDto.build();
    }

    protected List<CatalogParagraphDto> paragraphListToCatalogParagraphDtoList(List<Catalog.Paragraph> list) {
        if ( list == null ) {
            return null;
        }

        List<CatalogParagraphDto> list1 = new ArrayList<CatalogParagraphDto>( list.size() );
        for ( Catalog.Paragraph paragraph : list ) {
            list1.add( paragraphToCatalogParagraphDto( paragraph ) );
        }

        return list1;
    }

    protected CatalogInstitutionalPageDto institutionalPageToCatalogInstitutionalPageDto(Catalog.InstitutionalPage institutionalPage) {
        if ( institutionalPage == null ) {
            return null;
        }

        CatalogInstitutionalPageDto.CatalogInstitutionalPageDtoBuilder catalogInstitutionalPageDto = CatalogInstitutionalPageDto.builder();

        catalogInstitutionalPageDto.id( institutionalPage.getId() );
        catalogInstitutionalPageDto.name( institutionalPage.getName() );
        catalogInstitutionalPageDto.abstractContent( institutionalPage.getAbstractContent() );
        catalogInstitutionalPageDto.category( institutionalPage.getCategory() );

        return catalogInstitutionalPageDto.build();
    }

    protected AuthorDto authorToAuthorDto(Author author) {
        if ( author == null ) {
            return null;
        }

        AuthorDto.AuthorDtoBuilder authorDto = AuthorDto.builder();

        authorDto.id( author.getId() );
        authorDto.firstName( author.getFirstName() );
        authorDto.lastName( author.getLastName() );
        authorDto.email( author.getEmail() );
        authorDto.orcid( author.getOrcid() );

        return authorDto.build();
    }

    protected List<AuthorDto> authorListToAuthorDtoList(List<Author> list) {
        if ( list == null ) {
            return null;
        }

        List<AuthorDto> list1 = new ArrayList<AuthorDto>( list.size() );
        for ( Author author : list ) {
            list1.add( authorToAuthorDto( author ) );
        }

        return list1;
    }

    protected CatalogTypeDto catalogTypeToCatalogTypeDto(Catalog.CatalogType catalogType) {
        if ( catalogType == null ) {
            return null;
        }

        CatalogTypeDto.CatalogTypeDtoBuilder catalogTypeDto = CatalogTypeDto.builder();

        catalogTypeDto.id( catalogType.getId() );
        catalogTypeDto.name( catalogType.getName() );
        catalogTypeDto.description( catalogType.getDescription() );
        catalogTypeDto.metadataId( catalogType.getMetadataId() );
        catalogTypeDto.createTs( catalogType.getCreateTs() );
        catalogTypeDto.updateTs( catalogType.getUpdateTs() );
        catalogTypeDto.deleteTs( catalogType.getDeleteTs() );

        return catalogTypeDto.build();
    }

    protected CatalogMetadataSetDto metadataSetToCatalogMetadataSetDto(Catalog.MetadataSet metadataSet) {
        if ( metadataSet == null ) {
            return null;
        }

        CatalogMetadataSetDto.CatalogMetadataSetDtoBuilder catalogMetadataSetDto = CatalogMetadataSetDto.builder();

        catalogMetadataSetDto.id( metadataSet.getId() );
        catalogMetadataSetDto.name( metadataSet.getName() );
        catalogMetadataSetDto.description( metadataSet.getDescription() );
        catalogMetadataSetDto.standard( metadataSet.isStandard() );

        return catalogMetadataSetDto.build();
    }

    protected CatalogPublicationDto publicationToCatalogPublicationDto(Catalog.Publication publication) {
        if ( publication == null ) {
            return null;
        }

        CatalogPublicationDto.CatalogPublicationDtoBuilder catalogPublicationDto = CatalogPublicationDto.builder();

        catalogPublicationDto.date( publication.getDate() );
        catalogPublicationDto.zipCode( publication.getZipCode() );
        catalogPublicationDto.city( publication.getCity() );
        catalogPublicationDto.region( publication.getRegion() );
        catalogPublicationDto.country( publication.getCountry() );

        return catalogPublicationDto.build();
    }

    protected CatalogManualReferenceDto manualReferenceToCatalogManualReferenceDto(Catalog.ManualReference manualReference) {
        if ( manualReference == null ) {
            return null;
        }

        CatalogManualReferenceDto.CatalogManualReferenceDtoBuilder catalogManualReferenceDto = CatalogManualReferenceDto.builder();

        catalogManualReferenceDto.title( manualReference.getTitle() );
        catalogManualReferenceDto.url( manualReference.getUrl() );
        catalogManualReferenceDto.authors( authorListToAuthorDtoList( manualReference.getAuthors() ) );
        catalogManualReferenceDto.volume( manualReference.getVolume() );
        catalogManualReferenceDto.paragraph( manualReference.getParagraph() );
        catalogManualReferenceDto.pages( manualReference.getPages() );
        catalogManualReferenceDto.publication( publicationToCatalogPublicationDto( manualReference.getPublication() ) );

        return catalogManualReferenceDto.build();
    }

    protected List<CatalogManualReferenceDto> manualReferenceListToCatalogManualReferenceDtoList(List<Catalog.ManualReference> list) {
        if ( list == null ) {
            return null;
        }

        List<CatalogManualReferenceDto> list1 = new ArrayList<CatalogManualReferenceDto>( list.size() );
        for ( Catalog.ManualReference manualReference : list ) {
            list1.add( manualReferenceToCatalogManualReferenceDto( manualReference ) );
        }

        return list1;
    }

    protected CatalogReferencesDto referencesToCatalogReferencesDto(Catalog.References references) {
        if ( references == null ) {
            return null;
        }

        CatalogReferencesDto.CatalogReferencesDtoBuilder catalogReferencesDto = CatalogReferencesDto.builder();

        List<String> list = references.getDois();
        if ( list != null ) {
            catalogReferencesDto.dois( new ArrayList<String>( list ) );
        }
        catalogReferencesDto.manualReferences( manualReferenceListToCatalogManualReferenceDtoList( references.getManualReferences() ) );

        return catalogReferencesDto.build();
    }

    protected CatalogMetadataDto metadataToCatalogMetadataDto(Catalog.Metadata metadata) {
        if ( metadata == null ) {
            return null;
        }

        CatalogMetadataDto.CatalogMetadataDtoBuilder catalogMetadataDto = CatalogMetadataDto.builder();

        catalogMetadataDto.key( metadata.getKey() );
        catalogMetadataDto.value( metadata.getValue() );

        return catalogMetadataDto.build();
    }

    protected List<CatalogMetadataDto> metadataListToCatalogMetadataDtoList(List<Catalog.Metadata> list) {
        if ( list == null ) {
            return null;
        }

        List<CatalogMetadataDto> list1 = new ArrayList<CatalogMetadataDto>( list.size() );
        for ( Catalog.Metadata metadata : list ) {
            list1.add( metadataToCatalogMetadataDto( metadata ) );
        }

        return list1;
    }

    protected CatalogResourceDto resourceToCatalogResourceDto(Catalog.Resource resource) {
        if ( resource == null ) {
            return null;
        }

        CatalogResourceDto.CatalogResourceDtoBuilder catalogResourceDto = CatalogResourceDto.builder();

        catalogResourceDto.name( resource.getName() );
        catalogResourceDto.description( resource.getDescription() );
        catalogResourceDto.url( resource.getUrl() );
        catalogResourceDto.type( resource.getType() );
        catalogResourceDto.mimeType( resource.getMimeType() );
        catalogResourceDto.createdBy( resource.getCreatedBy() );
        catalogResourceDto.createdAt( resource.getCreatedAt() );
        catalogResourceDto.updatedBy( resource.getUpdatedBy() );
        catalogResourceDto.updatedAt( resource.getUpdatedAt() );

        return catalogResourceDto.build();
    }

    protected List<CatalogResourceDto> resourceListToCatalogResourceDtoList(List<Catalog.Resource> list) {
        if ( list == null ) {
            return null;
        }

        List<CatalogResourceDto> list1 = new ArrayList<CatalogResourceDto>( list.size() );
        for ( Catalog.Resource resource : list ) {
            list1.add( resourceToCatalogResourceDto( resource ) );
        }

        return list1;
    }

    private LocalDate entityPublicationDate(Catalog catalog) {
        Catalog.Publication publication = catalog.getPublication();
        if ( publication == null ) {
            return null;
        }
        return publication.getDate();
    }
}
