package com.finconsgroup.itserr.marketplace.search.dm.bean;

import com.finconsgroup.itserr.marketplace.core.web.bean.QueryFilter;
import lombok.Builder;

/**
 * The result of applying the post-processing logic to query filters.
 *
 * @param processed the flag to indicated if the filter was processed
 * @param skip the flag to indicate if this filter should be skipped and not applied to the query
 * @param queryFilter the processed query filter, if any
 */
@Builder
public record PostProcessFilterResult(boolean processed, boolean skip, QueryFilter queryFilter) {

}