package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.ToString;

/**
 * It represents the result for autocompletion data representing individual document of Global Search
 * or may also include user search favorites.
 */
@RequiredArgsConstructor
@Getter
@Builder
@Schema(
    title = "Global Search Auto Complete Result Data DTO",
    description = "Represents the response for Global Search document for auto complete"
)
@EqualsAndHashCode
@ToString
public class OutputGlobalSearchAutoCompleteDataDto {
    @Schema(
        description = "Document Id",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private final String id;
    @Schema(
        description = "Title",
        example = "Workspace - ITSERR Shared")
    private final String title;
    @Schema(
        description = "The score from the search result",
        example = "1.0",
        hidden = true)
    private final Double score;
}
