package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;
import java.util.List;

/**
 * It represents the response for an Institutional Page search document for local search.
 */
@Builder
@Schema(
    title = "Institutional Page search document response DTO for local search",
    description = "Represents the response for Institutional Page search document for local search"
)
@Data
public class OutputInstitutionalPageLocalSearchDto {
    @Schema(description = "ID", example = "123e4567-e89b-12d3-a456-426614174000")
    private String id;

    @Schema(description = "Name", example = "WP3 - T-Res")
    private String name;

    @Schema(description = "Category", example = "project")
    private String category;

    @Schema(description = "Abstract Content", example = "Test Abstract")
    private String abstractContent;

    @Schema(description = "The application version", example = "v1.3.0")
    private String applicationVersion;

    @Schema(description = "Publication Time", example = "2025-05-26T14:19:46.606883Z")
    private Instant publicationTime;

    @Schema(description = "Indicates whether the institutional page is published", example = "true")
    private Boolean published;

    @Schema(description = "Tags", example = "[\"ITALIAN\",\"RELIGIOUS\"]")
    private List<String> tags;

    @Schema(description = "Profile of the maintainer of the institutional page")
    private UserProfileMinimalDto maintainer;

    @Schema(description = "Image URL", example = "http://localhost/test/image.png")
    private String imageUrl;

    @Schema(description = "Work Package Leads")
    private List<UserProfileMinimalDto> wpLeads;

    @Schema(description = "Created At", example = "2025-05-26T14:19:46.606883Z")
    private Instant creationTime;

    @Schema(description = "Last Updated At", example = "2025-05-27T14:19:46.606883Z")
    private Instant updateTime;

    @Schema(description = "Indicates whether the institutional page is waiting to be deleted", example = "true")
    private Boolean toDelete;

    @Schema(description = "Indicates whether the institutional page has an updated version", example = "true")
    private Boolean hasUpdatedVersion;
}
