package com.finconsgroup.itserr.marketplace.search.dm.event;

import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfile;
import org.springframework.context.ApplicationEvent;

import java.util.Objects;

/**
 * Application event when minimal details of user profile are updated
 */
public class UserProfileUpdatedEvent extends ApplicationEvent {
    private final UserProfile oldUserProfile;

    public UserProfileUpdatedEvent(UserProfile source,
                                   UserProfile oldUserProfile) {
        super(source);
        this.oldUserProfile = oldUserProfile;
    }

    public UserProfileUpdatedEvent(UserProfile source) {
        this(source, null);
    }

    /**
     * The user profile on which the event occurred.
     *
     * @return the updated {@link UserProfile}
     */
    public UserProfile getUserProfile() {
        return (UserProfile) source;
    }

    /**
     * Checks if the minimal details of user profile has been updated
     *
     * @return {@code true} if updated
     */
    public boolean isUserProfileMinimalUpdated() {
        if (oldUserProfile == null) {
            return true;
        }

        UserProfile newUserProfile = getUserProfile();
        return !Objects.equals(newUserProfile.getFirstName(), oldUserProfile.getFirstName())
                || !Objects.equals(newUserProfile.getLastName(), oldUserProfile.getLastName())
                || !Objects.equals(newUserProfile.getEmail(), oldUserProfile.getEmail())
                || !Objects.equals(newUserProfile.getOrcid(), oldUserProfile.getOrcid());
    }

    /**
     * Checks if the location of user profile has been updated
     *
     * @return {@code true} if updated
     */
    public boolean isLocationUpdated() {
        if (oldUserProfile == null) {
            return getUserProfile().getWorkingLocation() != null;
        }

        return !Objects.equals(getUserProfile().getWorkingLocation(), oldUserProfile.getWorkingLocation());
    }
}
