package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import com.finconsgroup.itserr.marketplace.search.dm.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputUserProfileLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.UserProfileMinimalDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfile;
import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfileMinimal;
import io.micrometer.common.util.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

/**
 * Mapper for all dto/entity conversions related to {@link UserProfile}
 */
@Mapper(config = MapperConfiguration.class)
public interface UserProfileMapper {
    String MAP_ENTITY_TO_TITLE = "mapEntityToTitle";

    @Mapping(target = "score", ignore = true)
    UserProfile toEntity(InputUserProfileDto dto);

    OutputUserProfileDto toDto(UserProfile entity);

    @Mapping(target = "title", source = "entity", qualifiedByName = MAP_ENTITY_TO_TITLE)
    OutputGlobalSearchAutoCompleteDataDto toAutoCompleteDataDto(UserProfile entity);

    OutputUserProfileLocalSearchDto toLocalSearchDto(UserProfile entity);

    @Mapping(target = "title", source = "entity", qualifiedByName = MAP_ENTITY_TO_TITLE)
    @Mapping(target = "description", source = "shortBio")
    OutputGlobalSearchDataDto toGlobalSearchDataDto(UserProfile entity);

    UserProfileMinimal fullEntityToMinimalEntity(UserProfile entity);

    UserProfileMinimal toMinimalEntity(UserProfileMinimalDto dto);

    UserProfileMinimalDto toMinimalDto(UserProfileMinimal dto);

    /**
     * Map firstName, lastName to title for UserProfile
     *
     * @param entity {@link UserProfile} entity
     * @return title for the user profile entity
     */
    @SuppressWarnings("unused")
    @Named(MAP_ENTITY_TO_TITLE)
    default String mapEntityToTitle(UserProfile entity) {
        if (StringUtils.isNotBlank(entity.getFirstName()) && StringUtils.isNotBlank(entity.getLastName())) {
            return entity.getFirstName() + " " + entity.getLastName();
        } else if (StringUtils.isNotBlank(entity.getFirstName())) {
            return entity.getFirstName();
        } else if (StringUtils.isNotBlank(entity.getLastName())) {
            return entity.getLastName();
        } else {
            return "";
        }
    }

}
