/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.search.dm.bean.SearchRequest;
import com.finconsgroup.itserr.marketplace.search.dm.config.DefaultSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.EventSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.SearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputEventDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputEventLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Event;
import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfile;
import com.finconsgroup.itserr.marketplace.search.dm.enums.Category;
import com.finconsgroup.itserr.marketplace.search.dm.event.UserProfileUpdatedEvent;
import com.finconsgroup.itserr.marketplace.search.dm.mapper.EventMapper;
import com.finconsgroup.itserr.marketplace.search.dm.mapper.impl.EventUserContextAwareMapper;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomAggregationRepository;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomQueryRepository;
import com.finconsgroup.itserr.marketplace.search.dm.repository.EventRepository;
import com.finconsgroup.itserr.marketplace.search.dm.service.EventService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultEventService
implements EventService,
ApplicationListener<UserProfileUpdatedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEventService.class);
    private static final String CREATOR_USER_ID_FIELD_NAME = "maintainer.id";
    private final EventRepository eventRepository;
    private final EventMapper eventMapper;
    private final EventSearchProperties eventSearchProperties;
    private final Map<String, String> sortFilterPropertyMap;

    public DefaultEventService(EventRepository eventRepository, EventMapper eventMapper, EventSearchProperties eventSearchProperties, DefaultSearchProperties defaultSearchProperties) {
        this.eventRepository = eventRepository;
        this.eventMapper = eventMapper;
        this.eventSearchProperties = eventSearchProperties;
        this.sortFilterPropertyMap = this.buildSortFilterPropertyMap(eventSearchProperties.search(), defaultSearchProperties.search().sortFilterPropertyMap());
    }

    @Transactional
    @NonNull
    public OutputEventDto upsertDocument(@NonNull InputEventDto dto) {
        Event event = this.eventMapper.toEntity(dto);
        Event savedEvent = (Event)this.eventRepository.save((Object)event);
        return this.eventMapper.toDto(savedEvent);
    }

    @Transactional(readOnly=true)
    @NonNull
    public OutputEventDto getDocument(@NonNull String id) {
        Event savedEvent = (Event)this.eventRepository.findById((Object)id).orElseThrow(() -> new WP2ResourceNotFoundException("search_dm_event_not_found"));
        return this.eventMapper.toDto(savedEvent);
    }

    @Transactional
    public void deleteDocument(@NonNull String id) {
        if (!this.eventRepository.existsById((Object)id)) {
            throw new WP2ResourceNotFoundException("search_dm_event_not_found");
        }
        this.eventRepository.deleteById((Object)id);
    }

    public void deleteAll() {
        if (!this.eventSearchProperties.search().enableDeleteAll()) {
            throw new WP2BusinessException("search_dm_event_delete_all_not_enabled");
        }
        this.eventRepository.deleteAll();
    }

    @NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String terms) {
        Page resultPage = this.search(SearchRequest.builder().terms(terms).build(), this.eventSearchProperties.search().autoCompletion().sourceFields(), arg_0 -> ((EventMapper)this.eventMapper).toAutoCompleteDataDto(arg_0), (Pageable)PageRequest.of((int)0, (int)this.eventSearchProperties.search().autoCompletion().topHitsLimit()));
        if (resultPage.isEmpty()) {
            return List.of();
        }
        return List.of(OutputGlobalSearchAutoCompleteDto.builder().category(Category.EVENT.getId()).data(resultPage.getContent()).build());
    }

    @NonNull
    @Transactional(readOnly=true)
    public Page<OutputEventLocalSearchDto> getLocalSearch(String terms, String filters, @NonNull Pageable pageable) {
        SearchRequest searchRequest = SearchRequest.builder().terms(terms).queryFilters(this.buildQueryFilters(filters, this.sortFilterPropertyMap)).build();
        Pageable sortedPageable = this.applySort(pageable, this.eventSearchProperties.search(), this.sortFilterPropertyMap);
        EventUserContextAwareMapper userContextAwareMapper = new EventUserContextAwareMapper((UUID)JwtTokenHolder.getUserId().orElse(null), this.eventMapper);
        return this.search(searchRequest, this.eventSearchProperties.search().local().sourceFields(), arg_0 -> ((EventUserContextAwareMapper)userContextAwareMapper).toLocalSearchDto(arg_0), sortedPageable);
    }

    @NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchDto> getSearch(@NonNull String terms) {
        Map searchResultAggregatedByType = this.searchByAggregation(SearchRequest.builder().terms(terms).build(), this.eventSearchProperties.search().globalSearch().sourceFields(), this.eventSearchProperties.search().globalSearch().topHitsLimit().intValue(), this.eventSearchProperties.search().globalSearch().aggregation(), arg_0 -> ((EventMapper)this.eventMapper).toGlobalSearchDataDto(arg_0));
        if (searchResultAggregatedByType.isEmpty()) {
            return List.of();
        }
        ArrayList<OutputGlobalSearchDto> globalSearchResults = new ArrayList<OutputGlobalSearchDto>();
        searchResultAggregatedByType.forEach((type, results) -> globalSearchResults.add(OutputGlobalSearchDto.builder().category(Category.EVENT.getId()).type(type).data(results).build()));
        return globalSearchResults;
    }

    public void onApplicationEvent(@NonNull UserProfileUpdatedEvent event) {
        try {
            if (event.isUserProfileMinimalUpdated()) {
                this.syncDocumentsForUserProfile(event.getUserProfile());
            }
        }
        catch (Exception ex) {
            log.error("Error occurred while syncing events for user profile with id - {}", (Object)event.getUserProfile().getId(), (Object)ex);
        }
    }

    @NonNull
    public Page<Event> searchDocumentsForUserProfileSync(@NonNull SearchRequest searchRequest, @NonNull Pageable pageable) {
        return this.search(searchRequest, null, Function.identity(), pageable);
    }

    public void syncDocumentForUserProfile(@NonNull Event event, @NonNull UserProfile userProfile) {
        boolean updated = false;
        if (event.getSubscribedParticipants() != null) {
            for (Event.SubscribedParticipant subscribedParticipant : event.getSubscribedParticipants()) {
                if (!Objects.equals(subscribedParticipant.getUserId(), userProfile.getId()) || this.isSubscriberUserProfileUpdated(subscribedParticipant, userProfile)) continue;
                this.updateSubscriberUserProfile(subscribedParticipant, userProfile);
                updated = true;
            }
        }
        if (event.getMaintainer() != null && Objects.equals(event.getMaintainer().getId(), userProfile.getId()) && !this.isUserProfileMinimalUpdated(event.getMaintainer(), userProfile)) {
            this.updateUserProfileMinimal(event.getMaintainer(), userProfile);
            updated = true;
        }
        if (event.getEventPlanner() != null && Objects.equals(event.getEventPlanner().getId(), userProfile.getId()) && !this.isUserProfileMinimalUpdated(event.getEventPlanner(), userProfile)) {
            this.updateUserProfileMinimal(event.getEventPlanner(), userProfile);
            updated = true;
        }
        if (updated) {
            this.eventRepository.save((Object)event);
        }
    }

    @NonNull
    public Class<Event> getDocumentClass() {
        return Event.class;
    }

    @NonNull
    public SearchProperties getSearchProperties() {
        return this.eventSearchProperties.search();
    }

    @NonNull
    public CustomQueryRepository getCustomQueryRepository() {
        return this.eventRepository;
    }

    @NonNull
    public CustomAggregationRepository getCustomAggregationRepository() {
        return this.eventRepository;
    }

    @NonNull
    public Optional<String> getCreatorUserIdFieldName() {
        return Optional.of(CREATOR_USER_ID_FIELD_NAME);
    }

    private boolean isSubscriberUserProfileUpdated(@NonNull Event.SubscribedParticipant subscribedParticipant, @NonNull UserProfile userProfile) {
        return !Objects.equals(subscribedParticipant.getFirstName(), userProfile.getFirstName()) || !Objects.equals(subscribedParticipant.getLastName(), userProfile.getLastName()) || !Objects.equals(subscribedParticipant.getEmail(), userProfile.getEmail()) || !Objects.equals(subscribedParticipant.getOrcid(), userProfile.getOrcid());
    }

    private void updateSubscriberUserProfile(@NonNull Event.SubscribedParticipant subscribedParticipant, @NonNull UserProfile userProfile) {
        subscribedParticipant.setFirstName(userProfile.getFirstName());
        subscribedParticipant.setLastName(userProfile.getLastName());
        subscribedParticipant.setEmail(userProfile.getEmail());
        subscribedParticipant.setOrcid(userProfile.getOrcid());
    }
}

