package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

/**
 * It represents the payload to create/update Author search field.
 */
@Builder
@Schema(
    title = "Create/Update Author Dto",
    description = "Represents the payload to create/update author field"
)
@Data
public class AuthorDto {

    @Schema(
            description = "User profile identifier (alternative to explicit details)",
            example = "3fa85f64-5717-4562-b3fc-2c963f66afa6"
    )
    private String id;

    @Schema(
        description = "First Name",
        example = "John")
    private String firstName;

    @Schema(
        description = "Last Name",
        example = "Doe")
    private String lastName;

    @Schema(
        description = "Email",
        example = "john.doe@example.com")
    private String email;

    @Schema(
        description = "orcid",
        example = "00000-00000-00000-00000")
    private String orcid;
}
