package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * It represents the persistent structure of additional fields field of Institutional Page for both Global and Local search.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class InstitutionalPageAdditionalFieldDto {

    @Schema(description = "Field Name", example = "param_one")
    private String fieldName;

    @Schema(description = "Field Value", example = "1234")
    private String fieldValue;
}
