/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.controller;

import com.finconsgroup.itserr.marketplace.search.dm.api.DiscussionApi;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputDiscussionDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputDiscussionDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputDiscussionLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.service.DiscussionService;
import com.finconsgroup.itserr.marketplace.search.dm.util.SortUtils;
import java.beans.PropertyEditor;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DiscussionController
implements DiscussionApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiscussionController.class);
    private final DiscussionService discussionService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(false));
    }

    @NonNull
    public OutputDiscussionDto upsertDiscussion(String id, InputDiscussionDto dto) {
        return (OutputDiscussionDto)this.discussionService.upsertDocument((Object)dto);
    }

    @NonNull
    public OutputDiscussionDto getDiscussion(String id) {
        return (OutputDiscussionDto)this.discussionService.getDocument(id);
    }

    public void deleteDiscussion(String id) {
        this.discussionService.deleteDocument(id);
    }

    public void deleteAll() {
        this.discussionService.deleteAll();
    }

    @NonNull
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String terms) {
        return this.discussionService.getAutoCompletions(terms);
    }

    @NonNull
    public Page<OutputDiscussionLocalSearchDto> getLocalSearch(@Nullable String terms, @Nullable String filters, int pageNumber, int pageSize, String sort, Sort.Direction direction, String multiSort) {
        Sort sortToApply = SortUtils.buildSort((String)sort, (Sort.Direction)direction, (String)multiSort, (String)":", Map.of());
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)sortToApply);
        return this.discussionService.getLocalSearch(terms, filters, (Pageable)pageable);
    }

    @Generated
    public DiscussionController(DiscussionService discussionService) {
        this.discussionService = discussionService;
    }
}

