/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.service;

import com.finconsgroup.itserr.marketplace.search.dm.bean.QuerySearchFields;
import com.finconsgroup.itserr.marketplace.search.dm.bean.SearchRequest;
import com.finconsgroup.itserr.marketplace.search.dm.config.SearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.entity.RegisteredAuthor;
import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfile;
import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfileMinimal;
import com.finconsgroup.itserr.marketplace.search.dm.enums.AssociationCategory;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;

public interface SyncUserProfileService<T> {
    public void syncDocumentForUserProfile(T var1, UserProfile var2);

    @NonNull
    public Page<T> searchDocumentsForUserProfileSync(@NonNull SearchRequest var1, @NonNull Pageable var2);

    @NonNull
    public SearchProperties getSearchProperties();

    default public void syncDocumentsForUserProfile(UserProfile userProfile) {
        PageRequest pageable;
        Page entityPage;
        if (this.getSearchProperties().syncList() == null) {
            return;
        }
        Optional<SearchProperties.SyncProperties> syncPropertiesOptional = this.getSearchProperties().syncList().stream().filter(sp -> AssociationCategory.PEOPLE.equals((Object)sp.associationCategory())).findFirst();
        if (syncPropertiesOptional.isEmpty()) {
            return;
        }
        QuerySearchFields querySearchFields = QuerySearchFields.builder().fieldType("keyword").fieldNames(syncPropertiesOptional.get().foreignKeyProperties()).build();
        SearchRequest searchRequest = SearchRequest.builder().terms(userProfile.getId()).termSearchFields(List.of(querySearchFields)).build();
        int page = 0;
        int pageSize = syncPropertiesOptional.get().fetchPageSize();
        while (!(entityPage = this.searchDocumentsForUserProfileSync(searchRequest, (Pageable)(pageable = PageRequest.of((int)page, (int)pageSize)))).isEmpty()) {
            entityPage.forEach(entity -> this.syncDocumentForUserProfile(entity, userProfile));
            if (entityPage.getNumberOfElements() >= pageSize && ++page < entityPage.getTotalPages()) continue;
            break;
        }
    }

    default public boolean isUserProfileMinimalUpdated(@NonNull UserProfileMinimal userProfileMinimal, @NonNull UserProfile userProfile) {
        return !Objects.equals(userProfile.getFirstName(), userProfileMinimal.getFirstName()) || !Objects.equals(userProfile.getLastName(), userProfileMinimal.getLastName()) || !Objects.equals(userProfile.getEmail(), userProfileMinimal.getEmail()) || !Objects.equals(userProfile.getOrcid(), userProfileMinimal.getOrcid());
    }

    default public void updateUserProfileMinimal(@NonNull UserProfileMinimal userProfileMinimal, @NonNull UserProfile userProfile) {
        userProfileMinimal.setFirstName(userProfile.getFirstName());
        userProfileMinimal.setLastName(userProfile.getLastName());
        userProfileMinimal.setEmail(userProfile.getEmail());
        userProfileMinimal.setOrcid(userProfile.getOrcid());
    }

    default public boolean isRegisteredAuthorUserProfileUpdated(@NonNull RegisteredAuthor registeredAuthor, @NonNull UserProfile userProfile) {
        return !Objects.equals(registeredAuthor.getFirstName(), userProfile.getFirstName()) || !Objects.equals(registeredAuthor.getLastName(), userProfile.getLastName()) || !Objects.equals(registeredAuthor.getEmail(), userProfile.getEmail()) || !Objects.equals(registeredAuthor.getOrcid(), userProfile.getOrcid()) || !Objects.equals(registeredAuthor.getLocation(), userProfile.getWorkingLocation());
    }

    default public void updateRegisteredAuthorUserProfile(@NonNull RegisteredAuthor registeredAuthor, @NonNull UserProfile userProfile) {
        registeredAuthor.setFirstName(userProfile.getFirstName());
        registeredAuthor.setLastName(userProfile.getLastName());
        registeredAuthor.setEmail(userProfile.getEmail());
        registeredAuthor.setOrcid(userProfile.getOrcid());
        registeredAuthor.setLocation(userProfile.getWorkingLocation());
    }
}

