/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputCVDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputExpertiseDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputProjectDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputReferenceDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserPreferenceDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputWorkingLocationDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Schema(name="OutputUserProfile", description="DTO representing a userprofile in responses")
public class OutputUserProfileDto {
    @Schema(description="Unique identifier of the user profile", example="550e8400-e29b-41d4-a716-446655440000")
    private UUID id;
    @Schema(description="First name of the user", example="John")
    private String firstName;
    @Schema(description="Last name of the user", example="Doe")
    private String lastName;
    @Schema(description="Email address of the user", example="john.doe@example.com")
    private String email;
    @Schema(description="preferred Username of the user", example="john.doe.213213")
    private String preferredUsername;
    @Schema(description="Whether the user exists or not", example="true")
    private boolean userExists;
    @Schema(description="Folder Id of the User Profile", example="550e8400-e29b-41d4-a716-446655440000")
    private UUID userProfileFolderId;
    @Schema(description="Link of the image of user", example="https://imageLink")
    private String imageUrl;
    @Schema(description="List of projects")
    @Valid
    private List<OutputProjectDto> projects;
    @Schema(description="CV details of the user")
    private OutputCVDto cv;
    @Schema(description="ORCID identifier of the user", example="0000-0002-1825-0097")
    private String orcid;
    @Schema(description="Whether the user is open to collaboration", example="false")
    private boolean openToCollaboration;
    @Schema(description="Whether the user's email is publicly visible", example="true")
    private boolean showPublicEmail;
    @Schema(description="Personal website URL", example="https://johndoe.example.com")
    private String personalWebsite;
    @Schema(description="LinkedIn profile URL", example="https://linkedin.com/in/johndoe")
    private String linkedinProfile;
    @Schema(description="Social profile URL (e.g., GitHub)", example="https://github.com/johndoe")
    private String socialProfile;
    @Schema(description="Short biography of the user", example="Ricercatore Legge 210/10 a tempo indeterminato")
    private String shortBio;
    @Schema(description="User's working location details")
    private OutputWorkingLocationDto workingLocation;
    @Schema(description="Organization affiliation", example="Stanford University")
    private String organizationAffiliation;
    @Schema(description="Scientific Disciplinary Sectors", example="[\"INF/01\", \"ING-INF/05\"]")
    private List<String> ssd;
    @Schema(description="Areas of Expertise")
    private List<OutputExpertiseDto> expertises;
    @Schema(description="List of references")
    @Valid
    private OutputReferenceDto references;
    @Schema(description="The creation time of the table record", example="2025-04-06T10:15:30+01:00")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;
    @Schema(description="The last update time of the table record", example="2025-04-06T10:15:30+01:00")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime updateTime;
    @Schema(description="User preferred language", example="EN")
    @NotBlank
    private String language;
    @Schema(description="Whether the user profile is private or public", example="false")
    private boolean publicProfile;
    @Schema(description=" thematic interests of user", example="[\"Physics\", \"Maths\"]")
    private List<String> interests;
    @Schema(description="Whether the user has enabled his email consent to get notifications", example="true")
    private boolean emailConsent;
    @Schema(description="User preferences")
    private OutputUserPreferenceDto preferences;
    @Schema(description="Whether to show home panel or not", example="false")
    private Boolean hidePanel;

    @Generated
    public static OutputUserProfileDtoBuilder builder() {
        return new OutputUserProfileDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getPreferredUsername() {
        return this.preferredUsername;
    }

    @Generated
    public boolean isUserExists() {
        return this.userExists;
    }

    @Generated
    public UUID getUserProfileFolderId() {
        return this.userProfileFolderId;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public List<OutputProjectDto> getProjects() {
        return this.projects;
    }

    @Generated
    public OutputCVDto getCv() {
        return this.cv;
    }

    @Generated
    public String getOrcid() {
        return this.orcid;
    }

    @Generated
    public boolean isOpenToCollaboration() {
        return this.openToCollaboration;
    }

    @Generated
    public boolean isShowPublicEmail() {
        return this.showPublicEmail;
    }

    @Generated
    public String getPersonalWebsite() {
        return this.personalWebsite;
    }

    @Generated
    public String getLinkedinProfile() {
        return this.linkedinProfile;
    }

    @Generated
    public String getSocialProfile() {
        return this.socialProfile;
    }

    @Generated
    public String getShortBio() {
        return this.shortBio;
    }

    @Generated
    public OutputWorkingLocationDto getWorkingLocation() {
        return this.workingLocation;
    }

    @Generated
    public String getOrganizationAffiliation() {
        return this.organizationAffiliation;
    }

    @Generated
    public List<String> getSsd() {
        return this.ssd;
    }

    @Generated
    public List<OutputExpertiseDto> getExpertises() {
        return this.expertises;
    }

    @Generated
    public OutputReferenceDto getReferences() {
        return this.references;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public boolean isPublicProfile() {
        return this.publicProfile;
    }

    @Generated
    public List<String> getInterests() {
        return this.interests;
    }

    @Generated
    public boolean isEmailConsent() {
        return this.emailConsent;
    }

    @Generated
    public OutputUserPreferenceDto getPreferences() {
        return this.preferences;
    }

    @Generated
    public Boolean getHidePanel() {
        return this.hidePanel;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setPreferredUsername(String preferredUsername) {
        this.preferredUsername = preferredUsername;
    }

    @Generated
    public void setUserExists(boolean userExists) {
        this.userExists = userExists;
    }

    @Generated
    public void setUserProfileFolderId(UUID userProfileFolderId) {
        this.userProfileFolderId = userProfileFolderId;
    }

    @Generated
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Generated
    public void setProjects(List<OutputProjectDto> projects) {
        this.projects = projects;
    }

    @Generated
    public void setCv(OutputCVDto cv) {
        this.cv = cv;
    }

    @Generated
    public void setOrcid(String orcid) {
        this.orcid = orcid;
    }

    @Generated
    public void setOpenToCollaboration(boolean openToCollaboration) {
        this.openToCollaboration = openToCollaboration;
    }

    @Generated
    public void setShowPublicEmail(boolean showPublicEmail) {
        this.showPublicEmail = showPublicEmail;
    }

    @Generated
    public void setPersonalWebsite(String personalWebsite) {
        this.personalWebsite = personalWebsite;
    }

    @Generated
    public void setLinkedinProfile(String linkedinProfile) {
        this.linkedinProfile = linkedinProfile;
    }

    @Generated
    public void setSocialProfile(String socialProfile) {
        this.socialProfile = socialProfile;
    }

    @Generated
    public void setShortBio(String shortBio) {
        this.shortBio = shortBio;
    }

    @Generated
    public void setWorkingLocation(OutputWorkingLocationDto workingLocation) {
        this.workingLocation = workingLocation;
    }

    @Generated
    public void setOrganizationAffiliation(String organizationAffiliation) {
        this.organizationAffiliation = organizationAffiliation;
    }

    @Generated
    public void setSsd(List<String> ssd) {
        this.ssd = ssd;
    }

    @Generated
    public void setExpertises(List<OutputExpertiseDto> expertises) {
        this.expertises = expertises;
    }

    @Generated
    public void setReferences(OutputReferenceDto references) {
        this.references = references;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public void setPublicProfile(boolean publicProfile) {
        this.publicProfile = publicProfile;
    }

    @Generated
    public void setInterests(List<String> interests) {
        this.interests = interests;
    }

    @Generated
    public void setEmailConsent(boolean emailConsent) {
        this.emailConsent = emailConsent;
    }

    @Generated
    public void setPreferences(OutputUserPreferenceDto preferences) {
        this.preferences = preferences;
    }

    @Generated
    public void setHidePanel(Boolean hidePanel) {
        this.hidePanel = hidePanel;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputUserProfileDto)) {
            return false;
        }
        OutputUserProfileDto other = (OutputUserProfileDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isUserExists() != other.isUserExists()) {
            return false;
        }
        if (this.isOpenToCollaboration() != other.isOpenToCollaboration()) {
            return false;
        }
        if (this.isShowPublicEmail() != other.isShowPublicEmail()) {
            return false;
        }
        if (this.isPublicProfile() != other.isPublicProfile()) {
            return false;
        }
        if (this.isEmailConsent() != other.isEmailConsent()) {
            return false;
        }
        Boolean this$hidePanel = this.getHidePanel();
        Boolean other$hidePanel = other.getHidePanel();
        if (this$hidePanel == null ? other$hidePanel != null : !((Object)this$hidePanel).equals(other$hidePanel)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$preferredUsername = this.getPreferredUsername();
        String other$preferredUsername = other.getPreferredUsername();
        if (this$preferredUsername == null ? other$preferredUsername != null : !this$preferredUsername.equals(other$preferredUsername)) {
            return false;
        }
        UUID this$userProfileFolderId = this.getUserProfileFolderId();
        UUID other$userProfileFolderId = other.getUserProfileFolderId();
        if (this$userProfileFolderId == null ? other$userProfileFolderId != null : !((Object)this$userProfileFolderId).equals(other$userProfileFolderId)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        List this$projects = this.getProjects();
        List other$projects = other.getProjects();
        if (this$projects == null ? other$projects != null : !((Object)this$projects).equals(other$projects)) {
            return false;
        }
        OutputCVDto this$cv = this.getCv();
        OutputCVDto other$cv = other.getCv();
        if (this$cv == null ? other$cv != null : !this$cv.equals(other$cv)) {
            return false;
        }
        String this$orcid = this.getOrcid();
        String other$orcid = other.getOrcid();
        if (this$orcid == null ? other$orcid != null : !this$orcid.equals(other$orcid)) {
            return false;
        }
        String this$personalWebsite = this.getPersonalWebsite();
        String other$personalWebsite = other.getPersonalWebsite();
        if (this$personalWebsite == null ? other$personalWebsite != null : !this$personalWebsite.equals(other$personalWebsite)) {
            return false;
        }
        String this$linkedinProfile = this.getLinkedinProfile();
        String other$linkedinProfile = other.getLinkedinProfile();
        if (this$linkedinProfile == null ? other$linkedinProfile != null : !this$linkedinProfile.equals(other$linkedinProfile)) {
            return false;
        }
        String this$socialProfile = this.getSocialProfile();
        String other$socialProfile = other.getSocialProfile();
        if (this$socialProfile == null ? other$socialProfile != null : !this$socialProfile.equals(other$socialProfile)) {
            return false;
        }
        String this$shortBio = this.getShortBio();
        String other$shortBio = other.getShortBio();
        if (this$shortBio == null ? other$shortBio != null : !this$shortBio.equals(other$shortBio)) {
            return false;
        }
        OutputWorkingLocationDto this$workingLocation = this.getWorkingLocation();
        OutputWorkingLocationDto other$workingLocation = other.getWorkingLocation();
        if (this$workingLocation == null ? other$workingLocation != null : !this$workingLocation.equals(other$workingLocation)) {
            return false;
        }
        String this$organizationAffiliation = this.getOrganizationAffiliation();
        String other$organizationAffiliation = other.getOrganizationAffiliation();
        if (this$organizationAffiliation == null ? other$organizationAffiliation != null : !this$organizationAffiliation.equals(other$organizationAffiliation)) {
            return false;
        }
        List this$ssd = this.getSsd();
        List other$ssd = other.getSsd();
        if (this$ssd == null ? other$ssd != null : !((Object)this$ssd).equals(other$ssd)) {
            return false;
        }
        List this$expertises = this.getExpertises();
        List other$expertises = other.getExpertises();
        if (this$expertises == null ? other$expertises != null : !((Object)this$expertises).equals(other$expertises)) {
            return false;
        }
        OutputReferenceDto this$references = this.getReferences();
        OutputReferenceDto other$references = other.getReferences();
        if (this$references == null ? other$references != null : !this$references.equals(other$references)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        List this$interests = this.getInterests();
        List other$interests = other.getInterests();
        if (this$interests == null ? other$interests != null : !((Object)this$interests).equals(other$interests)) {
            return false;
        }
        OutputUserPreferenceDto this$preferences = this.getPreferences();
        OutputUserPreferenceDto other$preferences = other.getPreferences();
        return !(this$preferences == null ? other$preferences != null : !this$preferences.equals(other$preferences));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutputUserProfileDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUserExists() ? 79 : 97);
        result = result * 59 + (this.isOpenToCollaboration() ? 79 : 97);
        result = result * 59 + (this.isShowPublicEmail() ? 79 : 97);
        result = result * 59 + (this.isPublicProfile() ? 79 : 97);
        result = result * 59 + (this.isEmailConsent() ? 79 : 97);
        Boolean $hidePanel = this.getHidePanel();
        result = result * 59 + ($hidePanel == null ? 43 : ((Object)$hidePanel).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $preferredUsername = this.getPreferredUsername();
        result = result * 59 + ($preferredUsername == null ? 43 : $preferredUsername.hashCode());
        UUID $userProfileFolderId = this.getUserProfileFolderId();
        result = result * 59 + ($userProfileFolderId == null ? 43 : ((Object)$userProfileFolderId).hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        List $projects = this.getProjects();
        result = result * 59 + ($projects == null ? 43 : ((Object)$projects).hashCode());
        OutputCVDto $cv = this.getCv();
        result = result * 59 + ($cv == null ? 43 : $cv.hashCode());
        String $orcid = this.getOrcid();
        result = result * 59 + ($orcid == null ? 43 : $orcid.hashCode());
        String $personalWebsite = this.getPersonalWebsite();
        result = result * 59 + ($personalWebsite == null ? 43 : $personalWebsite.hashCode());
        String $linkedinProfile = this.getLinkedinProfile();
        result = result * 59 + ($linkedinProfile == null ? 43 : $linkedinProfile.hashCode());
        String $socialProfile = this.getSocialProfile();
        result = result * 59 + ($socialProfile == null ? 43 : $socialProfile.hashCode());
        String $shortBio = this.getShortBio();
        result = result * 59 + ($shortBio == null ? 43 : $shortBio.hashCode());
        OutputWorkingLocationDto $workingLocation = this.getWorkingLocation();
        result = result * 59 + ($workingLocation == null ? 43 : $workingLocation.hashCode());
        String $organizationAffiliation = this.getOrganizationAffiliation();
        result = result * 59 + ($organizationAffiliation == null ? 43 : $organizationAffiliation.hashCode());
        List $ssd = this.getSsd();
        result = result * 59 + ($ssd == null ? 43 : ((Object)$ssd).hashCode());
        List $expertises = this.getExpertises();
        result = result * 59 + ($expertises == null ? 43 : ((Object)$expertises).hashCode());
        OutputReferenceDto $references = this.getReferences();
        result = result * 59 + ($references == null ? 43 : $references.hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        List $interests = this.getInterests();
        result = result * 59 + ($interests == null ? 43 : ((Object)$interests).hashCode());
        OutputUserPreferenceDto $preferences = this.getPreferences();
        result = result * 59 + ($preferences == null ? 43 : $preferences.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OutputUserProfileDto(id=" + String.valueOf(this.getId()) + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", email=" + this.getEmail() + ", preferredUsername=" + this.getPreferredUsername() + ", userExists=" + this.isUserExists() + ", userProfileFolderId=" + String.valueOf(this.getUserProfileFolderId()) + ", imageUrl=" + this.getImageUrl() + ", projects=" + String.valueOf(this.getProjects()) + ", cv=" + String.valueOf(this.getCv()) + ", orcid=" + this.getOrcid() + ", openToCollaboration=" + this.isOpenToCollaboration() + ", showPublicEmail=" + this.isShowPublicEmail() + ", personalWebsite=" + this.getPersonalWebsite() + ", linkedinProfile=" + this.getLinkedinProfile() + ", socialProfile=" + this.getSocialProfile() + ", shortBio=" + this.getShortBio() + ", workingLocation=" + String.valueOf(this.getWorkingLocation()) + ", organizationAffiliation=" + this.getOrganizationAffiliation() + ", ssd=" + String.valueOf(this.getSsd()) + ", expertises=" + String.valueOf(this.getExpertises()) + ", references=" + String.valueOf(this.getReferences()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", language=" + this.getLanguage() + ", publicProfile=" + this.isPublicProfile() + ", interests=" + String.valueOf(this.getInterests()) + ", emailConsent=" + this.isEmailConsent() + ", preferences=" + String.valueOf(this.getPreferences()) + ", hidePanel=" + this.getHidePanel() + ")";
    }

    @Generated
    public OutputUserProfileDto() {
    }

    @Generated
    public OutputUserProfileDto(UUID id, String firstName, String lastName, String email, String preferredUsername, boolean userExists, UUID userProfileFolderId, String imageUrl, List<OutputProjectDto> projects, OutputCVDto cv, String orcid, boolean openToCollaboration, boolean showPublicEmail, String personalWebsite, String linkedinProfile, String socialProfile, String shortBio, OutputWorkingLocationDto workingLocation, String organizationAffiliation, List<String> ssd, List<OutputExpertiseDto> expertises, OutputReferenceDto references, ZonedDateTime creationTime, ZonedDateTime updateTime, String language, boolean publicProfile, List<String> interests, boolean emailConsent, OutputUserPreferenceDto preferences, Boolean hidePanel) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.preferredUsername = preferredUsername;
        this.userExists = userExists;
        this.userProfileFolderId = userProfileFolderId;
        this.imageUrl = imageUrl;
        this.projects = projects;
        this.cv = cv;
        this.orcid = orcid;
        this.openToCollaboration = openToCollaboration;
        this.showPublicEmail = showPublicEmail;
        this.personalWebsite = personalWebsite;
        this.linkedinProfile = linkedinProfile;
        this.socialProfile = socialProfile;
        this.shortBio = shortBio;
        this.workingLocation = workingLocation;
        this.organizationAffiliation = organizationAffiliation;
        this.ssd = ssd;
        this.expertises = expertises;
        this.references = references;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
        this.language = language;
        this.publicProfile = publicProfile;
        this.interests = interests;
        this.emailConsent = emailConsent;
        this.preferences = preferences;
        this.hidePanel = hidePanel;
    }
}

