/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.CVEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.UserProfileEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;

@Entity
@Table(name="cv")
public class CVEntity
extends AbstractUUIDEntity {
    @OneToOne
    @JoinColumn(name="user_profile_id", nullable=false)
    private UserProfileEntity userProfile;
    @Column(name="file_url", nullable=false)
    private String fileUrl;
    @Column(name="filename", nullable=false)
    private String filename;
    @Column(name="size", nullable=false)
    private long size;
    @Column(name="creation_time", nullable=false, updatable=false)
    private ZonedDateTime creationTime;
    @Column(name="update_time", nullable=false)
    private ZonedDateTime updateTime;
    @Version
    private long version;

    public void prePersist() {
        super.prePersist();
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
    }

    @Generated
    protected CVEntity(CVEntityBuilder<?, ?> b) {
        super(b);
        this.userProfile = b.userProfile;
        this.fileUrl = b.fileUrl;
        this.filename = b.filename;
        this.size = b.size;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
    }

    @Generated
    public static CVEntityBuilder<?, ?> builder() {
        return new CVEntityBuilderImpl();
    }

    @Generated
    public UserProfileEntity getUserProfile() {
        return this.userProfile;
    }

    @Generated
    public String getFileUrl() {
        return this.fileUrl;
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setUserProfile(UserProfileEntity userProfile) {
        this.userProfile = userProfile;
    }

    @Generated
    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    @Generated
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Generated
    public void setSize(long size) {
        this.size = size;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "CVEntity(userProfile=" + String.valueOf(this.getUserProfile()) + ", fileUrl=" + this.getFileUrl() + ", filename=" + this.getFilename() + ", size=" + this.getSize() + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CVEntity)) {
            return false;
        }
        CVEntity other = (CVEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$fileUrl = this.getFileUrl();
        String other$fileUrl = other.getFileUrl();
        if (this$fileUrl == null ? other$fileUrl != null : !this$fileUrl.equals(other$fileUrl)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CVEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $fileUrl = this.getFileUrl();
        result = result * 59 + ($fileUrl == null ? 43 : $fileUrl.hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public CVEntity() {
    }
}

