/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ArchivedEndorsementEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ArchivedExpertiseEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.EndorsementEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ExpertiseEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.ArchivedEndorsementMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.ArchivedExpertiseMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ArchivedExpertiseMapperImpl
implements ArchivedExpertiseMapper {
    @Autowired
    private ArchivedEndorsementMapper archivedEndorsementMapper;

    public ArchivedExpertiseEntity toArchivedEntity(ExpertiseEntity src) {
        if (src == null) {
            return null;
        }
        ArchivedExpertiseEntity.ArchivedExpertiseEntityBuilder archivedExpertiseEntity = ArchivedExpertiseEntity.builder();
        archivedExpertiseEntity.id(src.getId());
        archivedExpertiseEntity.userProfile(src.getUserProfile());
        archivedExpertiseEntity.labelId(src.getLabelId());
        archivedExpertiseEntity.displayName(src.getDisplayName());
        archivedExpertiseEntity.endorsementCount(src.getEndorsementCount());
        archivedExpertiseEntity.endorsements(this.endorsementEntityListToArchivedEndorsementEntityList(src.getEndorsements()));
        archivedExpertiseEntity.expertiseOrder(src.getExpertiseOrder());
        archivedExpertiseEntity.creationTime(src.getCreationTime());
        archivedExpertiseEntity.updateTime(src.getUpdateTime());
        archivedExpertiseEntity.version(src.getVersion());
        return archivedExpertiseEntity.build();
    }

    protected List<ArchivedEndorsementEntity> endorsementEntityListToArchivedEndorsementEntityList(List<EndorsementEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ArchivedEndorsementEntity> list1 = new ArrayList<ArchivedEndorsementEntity>(list.size());
        for (EndorsementEntity endorsementEntity : list) {
            list1.add(this.archivedEndorsementMapper.toArchivedEntity(endorsementEntity));
        }
        return list1;
    }
}

