/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputPublicationDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputWorkingLocationDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputPublicationDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputWorkingLocationDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.PublicationEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.PublicationMapper;
import org.springframework.stereotype.Component;

@Component
public class PublicationMapperImpl
implements PublicationMapper {
    public PublicationEntity toEntity(InputPublicationDto dto) {
        if (dto == null) {
            return null;
        }
        PublicationEntity.PublicationEntityBuilder publicationEntity = PublicationEntity.builder();
        publicationEntity.city(this.dtoLocationCity(dto));
        publicationEntity.region(this.dtoLocationRegion(dto));
        publicationEntity.country(this.dtoLocationCountry(dto));
        publicationEntity.zipCode(this.dtoLocationZipCode(dto));
        publicationEntity.date(dto.getDate());
        return publicationEntity.build();
    }

    public OutputPublicationDto toDto(PublicationEntity entity) {
        if (entity == null) {
            return null;
        }
        OutputPublicationDto.OutputPublicationDtoBuilder outputPublicationDto = OutputPublicationDto.builder();
        outputPublicationDto.location(this.publicationEntityToOutputWorkingLocationDto(entity));
        outputPublicationDto.date(entity.getDate());
        return outputPublicationDto.build();
    }

    private String dtoLocationCity(InputPublicationDto inputPublicationDto) {
        InputWorkingLocationDto location = inputPublicationDto.getLocation();
        if (location == null) {
            return null;
        }
        return location.getCity();
    }

    private String dtoLocationRegion(InputPublicationDto inputPublicationDto) {
        InputWorkingLocationDto location = inputPublicationDto.getLocation();
        if (location == null) {
            return null;
        }
        return location.getRegion();
    }

    private String dtoLocationCountry(InputPublicationDto inputPublicationDto) {
        InputWorkingLocationDto location = inputPublicationDto.getLocation();
        if (location == null) {
            return null;
        }
        return location.getCountry();
    }

    private String dtoLocationZipCode(InputPublicationDto inputPublicationDto) {
        InputWorkingLocationDto location = inputPublicationDto.getLocation();
        if (location == null) {
            return null;
        }
        return location.getZipCode();
    }

    protected OutputWorkingLocationDto publicationEntityToOutputWorkingLocationDto(PublicationEntity publicationEntity) {
        if (publicationEntity == null) {
            return null;
        }
        OutputWorkingLocationDto.OutputWorkingLocationDtoBuilder outputWorkingLocationDto = OutputWorkingLocationDto.builder();
        outputWorkingLocationDto.city(publicationEntity.getCity());
        outputWorkingLocationDto.region(publicationEntity.getRegion());
        outputWorkingLocationDto.country(publicationEntity.getCountry());
        outputWorkingLocationDto.zipCode(publicationEntity.getZipCode());
        return outputWorkingLocationDto.build();
    }
}

