/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2DuplicateResourceException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ValidationException;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputEndorsementAcknowledgementDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ArchivedEndorsementEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ArchivedExpertiseEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.EndorsementEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ExpertiseEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.ArchivedEndorsementMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.EndorsementMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.repository.ArchivedEndorsementRepository;
import com.finconsgroup.itserr.marketplace.userprofile.dm.repository.EndorsementRepository;
import com.finconsgroup.itserr.marketplace.userprofile.dm.repository.ExpertiseRepository;
import com.finconsgroup.itserr.marketplace.userprofile.dm.service.EndorsementService;
import com.finconsgroup.itserr.marketplace.userprofile.dm.service.UserProfileService;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultEndorsementService
implements EndorsementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEndorsementService.class);
    private static final String EXPERTISE_USER_BUSINESS_KEY = "{expertiseId: %s, userId: %s}";
    private static final String USER_PROFILE_BUSINESS_KEY = "{user cannot endorse their own expertise. userId: %s, profileId: %s}";
    private final ExpertiseRepository expertiseRepository;
    private final EndorsementRepository endorsementRepository;
    private final EndorsementMapper endorsementMapper;
    private final ArchivedEndorsementRepository archivedEndorsementRepository;
    private final ArchivedEndorsementMapper archivedEndorsementMapper;
    private final UserProfileService userProfileService;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputEndorsementAcknowledgementDto addEndorsement(@NonNull UUID userId, @NonNull UUID profileId, @NonNull UUID expertiseId) {
        if (userId.equals(profileId)) {
            throw new WP2ValidationException(USER_PROFILE_BUSINESS_KEY.formatted(userId, profileId));
        }
        if (this.endorsementRepository.existsByExpertiseIdAndEndorserId(expertiseId, userId)) {
            throw new WP2DuplicateResourceException(EXPERTISE_USER_BUSINESS_KEY.formatted(expertiseId, userId));
        }
        ExpertiseEntity existingExpertiseEntity = this.findByIdAndUserIdOrThrow(expertiseId, profileId);
        EndorsementEntity endorsementEntity = EndorsementEntity.builder().expertise(existingExpertiseEntity).expertiseId(expertiseId).endorserId(userId).endorsementOrder((long)existingExpertiseEntity.getEndorsementCount().intValue()).build();
        EndorsementEntity savedEndorsementEntity = (EndorsementEntity)this.endorsementRepository.saveAndFlush((Object)endorsementEntity);
        existingExpertiseEntity.incrementEndorsements();
        this.expertiseRepository.saveAndFlush((Object)existingExpertiseEntity);
        OutputUserProfileDto outputUserProfileDto = this.userProfileService.getById(userId);
        return this.endorsementMapper.toEndorsementAcknowledgementDto(savedEndorsementEntity, outputUserProfileDto, profileId, existingExpertiseEntity.getDisplayName());
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void removeEndorsement(@NonNull UUID userId, @NonNull UUID profileId, @NonNull UUID expertiseId) {
        EndorsementEntity endorsementEntity = (EndorsementEntity)this.endorsementRepository.findByExpertiseIdAndEndorserId(expertiseId, userId).orElseThrow(() -> new WP2ResourceNotFoundException(EXPERTISE_USER_BUSINESS_KEY.formatted(expertiseId, userId)));
        this.endorsementRepository.delete((Object)endorsementEntity);
        ArchivedEndorsementEntity archivedEndorsementEntity = this.archivedEndorsementMapper.toArchivedEntity(endorsementEntity);
        archivedEndorsementEntity.setExpertise(((ArchivedExpertiseEntity.ArchivedExpertiseEntityBuilder)ArchivedExpertiseEntity.builder().id(expertiseId)).build());
        this.archivedEndorsementRepository.save((Object)archivedEndorsementEntity);
        ExpertiseEntity existingExpertiseEntity = this.findByIdAndUserIdOrThrow(expertiseId, profileId);
        existingExpertiseEntity.decrementEndorsements();
        this.expertiseRepository.saveAndFlush((Object)existingExpertiseEntity);
    }

    private ExpertiseEntity findByIdAndUserIdOrThrow(@NonNull UUID expertiseId, @NonNull UUID profileId) {
        return (ExpertiseEntity)this.expertiseRepository.findByIdAndUserProfileId(expertiseId, profileId).orElseThrow(() -> new WP2ResourceNotFoundException(EXPERTISE_USER_BUSINESS_KEY.formatted(expertiseId, profileId)));
    }

    @Generated
    public DefaultEndorsementService(ExpertiseRepository expertiseRepository, EndorsementRepository endorsementRepository, EndorsementMapper endorsementMapper, ArchivedEndorsementRepository archivedEndorsementRepository, ArchivedEndorsementMapper archivedEndorsementMapper, UserProfileService userProfileService) {
        this.expertiseRepository = expertiseRepository;
        this.endorsementRepository = endorsementRepository;
        this.endorsementMapper = endorsementMapper;
        this.archivedEndorsementRepository = archivedEndorsementRepository;
        this.archivedEndorsementMapper = archivedEndorsementMapper;
        this.userProfileService = userProfileService;
    }
}

