create schema if not exists "wp2_user_profile";

set schema 'wp2_user_profile';

-- liquibase formatted sql

-- changeset vishal.raut:1760092290586-1
CREATE TABLE "user_profile" ("id" UUID NOT NULL, "first_name" VARCHAR(100) NOT NULL, "last_name" VARCHAR(100) NOT NULL, "email" VARCHAR(255) NOT NULL, "profile_folder_id" UUID, "image_url" VARCHAR(255), "orcid" VARCHAR(255), "open_to_collaboration" BOOLEAN, "show_public_email" BOOLEAN, "personal_website" VARCHAR(255), "linkedin_profile" VARCHAR(255), "social_profile" VARCHAR(255), "short_bio" VARCHAR(1000), "organization_affiliation" VARCHAR(255), "ssd" TEXT, "expertises" TEXT, "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL, "update_time" TIMESTAMP WITH TIME ZONE NOT NULL, "version" BIGINT DEFAULT 0 NOT NULL, "language" VARCHAR(10) DEFAULT 'EN' NOT NULL, "preferred_username" VARCHAR(100), "public_profile" BOOLEAN, "interests" TEXT, "email_consent" BOOLEAN DEFAULT FALSE, "hide_panel" BOOLEAN DEFAULT FALSE, CONSTRAINT "user_profile_pkey" PRIMARY KEY ("id"));

-- changeset vishal.raut:1760092290586-2
CREATE TABLE "cv" ("id" UUID NOT NULL, "user_profile_id" UUID, "file_url" VARCHAR(255), "filename" VARCHAR(255), "size" BIGINT NOT NULL, "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL, "update_time" TIMESTAMP WITH TIME ZONE NOT NULL, "version" BIGINT DEFAULT 0 NOT NULL, CONSTRAINT "cv_pkey" PRIMARY KEY ("id"));

-- changeset vishal.raut:1760092290586-3
CREATE TABLE "working_location" ("id" UUID NOT NULL, "user_profile_id" UUID NOT NULL, "city" VARCHAR(100), "region" VARCHAR(100), "country" VARCHAR(100), "zip_code" VARCHAR(100), "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL, "update_time" TIMESTAMP WITH TIME ZONE NOT NULL, "version" BIGINT DEFAULT 0 NOT NULL, CONSTRAINT "working_location_pkey" PRIMARY KEY ("id"));

-- changeset vishal.raut:1760092290586-4
CREATE TABLE "reference" ("id" UUID NOT NULL, "user_profile_id" UUID NOT NULL, "dois" TEXT, "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL, "update_time" TIMESTAMP WITH TIME ZONE NOT NULL, "version" BIGINT DEFAULT 0 NOT NULL, CONSTRAINT "reference_pkey" PRIMARY KEY ("id"));

-- changeset vishal.raut:1760092290586-5
CREATE TABLE "manual_reference" ("id" UUID NOT NULL, "reference_id" UUID NOT NULL, "title" VARCHAR(255), "journal_or_conference" VARCHAR(255), "url" VARCHAR(255), "volume" VARCHAR(100), "pages" VARCHAR(100), "paragraph" VARCHAR(100), "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL, "update_time" TIMESTAMP WITH TIME ZONE NOT NULL, "version" BIGINT DEFAULT 0 NOT NULL, CONSTRAINT "manual_reference_pkey" PRIMARY KEY ("id"));

-- changeset vishal.raut:1760092290586-6
CREATE TABLE "publication" ("id" UUID NOT NULL, "manual_reference_id" UUID NOT NULL, "date" date, "city" VARCHAR(100), "region" VARCHAR(100), "country" VARCHAR(100), "zip_code" VARCHAR(100), "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL, "update_time" TIMESTAMP WITH TIME ZONE NOT NULL, "version" BIGINT DEFAULT 0 NOT NULL, CONSTRAINT "publication_pkey" PRIMARY KEY ("id"));

-- changeset vishal.raut:1760092290586-7
CREATE TABLE "author" ("id" UUID NOT NULL, "manual_reference_id" UUID NOT NULL, "first_name" VARCHAR(100), "last_name" VARCHAR(100), "email" VARCHAR(255), "orcid" VARCHAR(255), "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL, "update_time" TIMESTAMP WITH TIME ZONE NOT NULL, "version" BIGINT DEFAULT 0 NOT NULL, CONSTRAINT "author_pkey" PRIMARY KEY ("id"));

-- changeset vishal.raut:1760092290586-8
CREATE TABLE "project" ("id" UUID NOT NULL, "user_profile_id" UUID NOT NULL, "project_id" UUID, "display_name" VARCHAR(255), "wp" VARCHAR(100), "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL, "update_time" TIMESTAMP WITH TIME ZONE NOT NULL, "version" BIGINT DEFAULT 0 NOT NULL, "root_project_id" UUID, "root_project_display_name" VARCHAR(255), "wp_lead" BOOLEAN, CONSTRAINT "project_pkey" PRIMARY KEY ("id"));

-- changeset vishal.raut:1760092290586-9
ALTER TABLE "author" ADD CONSTRAINT "author_manual_reference_id_fkey" FOREIGN KEY ("manual_reference_id") REFERENCES "manual_reference" ("id") ON UPDATE NO ACTION ON DELETE CASCADE;

-- changeset vishal.raut:1760092290586-10
ALTER TABLE "cv" ADD CONSTRAINT "cv_user_profile_id_fkey" FOREIGN KEY ("user_profile_id") REFERENCES "user_profile" ("id") ON UPDATE NO ACTION ON DELETE CASCADE;

-- changeset vishal.raut:1760092290586-11
ALTER TABLE "manual_reference" ADD CONSTRAINT "manual_reference_reference_id_fkey" FOREIGN KEY ("reference_id") REFERENCES "reference" ("id") ON UPDATE NO ACTION ON DELETE CASCADE;

-- changeset vishal.raut:1760092290586-12
ALTER TABLE "project" ADD CONSTRAINT "project_user_profile_id_fkey" FOREIGN KEY ("user_profile_id") REFERENCES "user_profile" ("id") ON UPDATE NO ACTION ON DELETE CASCADE;

-- changeset vishal.raut:1760092290586-13
ALTER TABLE "publication" ADD CONSTRAINT "publication_manual_reference_id_fkey" FOREIGN KEY ("manual_reference_id") REFERENCES "manual_reference" ("id") ON UPDATE NO ACTION ON DELETE CASCADE;

-- changeset vishal.raut:1760092290586-14
ALTER TABLE "reference" ADD CONSTRAINT "reference_user_profile_id_fkey" FOREIGN KEY ("user_profile_id") REFERENCES "user_profile" ("id") ON UPDATE NO ACTION ON DELETE CASCADE;

-- changeset vishal.raut:1760092290586-15
ALTER TABLE "working_location" ADD CONSTRAINT "working_location_user_profile_id_fkey" FOREIGN KEY ("user_profile_id") REFERENCES "user_profile" ("id") ON UPDATE NO ACTION ON DELETE CASCADE;

-- changeset anant.singh:1760092290586-16
CREATE TABLE "user_preference" ("id" UUID NOT NULL, "user_profile_id" UUID NOT NULL, "theme" VARCHAR(100), "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL, "update_time" TIMESTAMP WITH TIME ZONE NOT NULL, "version" BIGINT DEFAULT 0 NOT NULL, CONSTRAINT "user_preference_pkey" PRIMARY KEY ("id"));

-- changeset anant.singh:1760092290586-17
ALTER TABLE "user_preference" ADD CONSTRAINT "user_preference_user_profile_id_fkey" FOREIGN KEY ("user_profile_id") REFERENCES "user_profile" ("id") ON UPDATE NO ACTION ON DELETE CASCADE;

--changeset anant.singh:20251110183738-18
ALTER TABLE "user_profile" DROP COLUMN IF EXISTS "expertises";

--changeset anant.singh:20251110184738-19
CREATE TABLE "expertise" ("id" uuid primary key, "user_profile_id" UUID NOT NULL, "label_id" UUID NOT NULL, "display_name" varchar(100), "endorsement_count" integer, "creation_time" timestamptz(6) NOT NULL, "update_time" timestamptz(6) NOT NULL, "version" bigint NOT NULL default 0, "expertise_order" bigint NOT NULL default 0 );

--changeset anant.singh:20251110185738-20
ALTER TABLE "expertise" ADD CONSTRAINT fk_expertise_user_id FOREIGN KEY (user_profile_id) REFERENCES "user_profile"(id) ON DELETE CASCADE;

--changeset anant.singh:20251110186738-21
CREATE TABLE "endorsement" ("id" uuid primary key, "expertise_id" UUID NOT NULL, "endorser_id" UUID NOT NULL, "creation_time" timestamptz(6) NOT NULL, "update_time" timestamptz(6) NOT NULL, "version" bigint NOT NULL default 0, "endorsement_order" bigint NOT NULL default 0 );

--changeset anant.singh:20251110187738-22
ALTER TABLE "endorsement" ADD CONSTRAINT fk_endorsement_expertise_id FOREIGN KEY (expertise_id) REFERENCES "expertise"(id) ON DELETE CASCADE;

--changeset anant.singh:20251110188738-23
CREATE TABLE "archived_expertise" ("id" uuid primary key, "user_profile_id" UUID NOT NULL, "label_id" UUID NOT NULL, "display_name" varchar(100), "endorsement_count" integer, "creation_time" timestamptz(6) NOT NULL, "update_time" timestamptz(6) NOT NULL, "archive_time" timestamptz(6) NOT NULL, "version" bigint NOT NULL default 0, "expertise_order" bigint NOT NULL default 0 );

--changeset anant.singh:20251110189738-24
CREATE TABLE "archived_endorsement" ("id" uuid primary key, "expertise_id" UUID NOT NULL, "endorser_id" UUID NOT NULL, "creation_time" timestamptz(6) NOT NULL, "update_time" timestamptz(6) NOT NULL, "archive_time" timestamptz(6) NOT NULL, "version" bigint NOT NULL default 0, "endorsement_order" bigint NOT NULL default 0 );