/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.zenodo.bs.api;

import com.finconsgroup.itserr.marketplace.zenodo.bs.dto.InputCreateZenodoExportDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.dto.OutputZenodoConfigDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Zenodo", description="The Zenodo API")
@SecurityRequirement(name="BearerAuth")
public interface ZenodoApi {
    @Operation(summary="Get Zenodo configuration", description="Retrieves the configuration details for the Zenodo integration including API host, OAuth client identifier, and required OAuth scopes")
    @ApiResponse(description="Successfully retrieved configuration")
    @GetMapping(path={"/zenodo/config"}, produces={"application/json"})
    public OutputZenodoConfigDto getZenodoConfig();

    @Operation(summary="Create new Zenodo export", description="Creates a new asynchronous export request to Zenodo with provided source and authentication details")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Export request accepted"), @ApiResponse(responseCode="403", description="The source item is visible to the user, but he has not enough permissions to export it to Zenodo"), @ApiResponse(responseCode="404", description="Source item not found or access is not authorized"), @ApiResponse(responseCode="422", description="User is not authenticated or the provided Zenodo auth code is invalid")})
    @PostMapping(path={"/zenodo/exports"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void createExport(@Parameter(description="Export request details", required=true) @Valid @NotNull @RequestBody InputCreateZenodoExportDto var1);
}

