/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.zenodo.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.zenodo.bs.messaging.EventProducer;
import com.finconsgroup.itserr.marketplace.zenodo.bs.messaging.configuration.properties.MessagingConfigurationProperties;
import com.finconsgroup.itserr.marketplace.zenodo.bs.messaging.dto.ExportRequestCreatedMessageBodyDto;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import com.finconsgroup.itserr.messaging.producer.MessageProducer;
import com.finconsgroup.itserr.messaging.producer.ProducerRegistry;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"messaging.enabled"}, havingValue="true")
public class DefaultEventProducer
implements EventProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEventProducer.class);
    private final MessageProducer messageProducer;
    private final MessagingConfigurationProperties messagingProperties;

    public DefaultEventProducer(MessagingConfigurationProperties messagingProperties, ProducerRegistry producerRegistry) {
        this.messagingProperties = messagingProperties;
        this.messageProducer = producerRegistry.getMessageProducer(this.messagingProperties.getEventProducerName());
    }

    public void publishExportRequestCreatedEvent(@NonNull ExportRequestCreatedMessageBodyDto resource) {
        this.publish(resource.getId(), (Object)resource, this.messagingProperties.getExportRequestCreatedEventType());
    }

    private <T> void publish(@NonNull String resourceId, @NonNull T resource, @NonNull String eventType) {
        try {
            Map<String, T> messageMap = Map.of(resourceId, resource);
            Map<String, String> filterProperties = Map.of("service", "zenodo");
            log.debug("Sending event message, messageMap:{}, eventType: {}, source: {}, filterProperties: {}", new Object[]{messageMap, eventType, this.messagingProperties.getSource(), filterProperties});
            this.messageProducer.publishEvent(messageMap, eventType, this.messagingProperties.getSource(), filterProperties);
            log.info("Successfully published event message for resource with id: {}", (Object)resourceId);
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while sending event message: %s".formatted(e.getMessage());
            throw new WP2MessagingException(errorMessage, (Throwable)e);
        }
    }
}

