package com.finconsgroup.itserr.marketplace.discussion.bs.messaging;

import com.finconsgroup.itserr.marketplace.discussion.bs.config.properties.ItemsProperties;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ResourceType;
import com.finconsgroup.itserr.marketplace.discussion.bs.service.DiscussionService;
import com.finconsgroup.itserr.marketplace.discussion.bs.utils.EntityStatusWrapper;
import com.finconsgroup.itserr.messaging.consumer.AbstractResourceSubscriber;
import com.finconsgroup.itserr.messaging.utils.CloudEventUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Component("catalogItemStatusSubscriber")
@RequiredArgsConstructor
@Slf4j
public class CatalogItemStatusSubscriber extends AbstractResourceSubscriber {

    private static final String OPERATION_TYPE_CREATE = "create";
    private static final String STATUS_APPROVED = "approved";

    private final DiscussionService discussionService;
    private final ItemsProperties itemsProperties;

    @Override
    protected void handleResource(String id, Object eventData, String eventType) {
        if (Objects.equals(eventType, itemsProperties.getResourceCreatedEventType())) {

            EntityStatusWrapper statusWrapper = CloudEventUtil.getObjectMapper()
                    .convertValue(eventData, EntityStatusWrapper.class);

            if (STATUS_APPROVED.equalsIgnoreCase(statusWrapper.getStatus())
                    && OPERATION_TYPE_CREATE.equalsIgnoreCase(statusWrapper.getAdditionalData().getOperationType())) {
                discussionService.createDiscussionFromEvent(id, eventData, ResourceType.ITEM.getValue());
            }
        }
    }
}
