/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.messaging;

import com.finconsgroup.itserr.marketplace.discussion.bs.config.properties.ItemsProperties;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ResourceType;
import com.finconsgroup.itserr.marketplace.discussion.bs.service.DiscussionService;
import com.finconsgroup.itserr.marketplace.discussion.bs.utils.EntityStatusWrapper;
import com.finconsgroup.itserr.messaging.consumer.AbstractResourceSubscriber;
import com.finconsgroup.itserr.messaging.utils.CloudEventUtil;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="catalogItemStatusSubscriber")
public class CatalogItemStatusSubscriber
extends AbstractResourceSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CatalogItemStatusSubscriber.class);
    private static final String OPERATION_TYPE_CREATE = "create";
    private static final String STATUS_APPROVED = "approved";
    private final DiscussionService discussionService;
    private final ItemsProperties itemsProperties;

    protected void handleResource(String id, Object eventData, String eventType) {
        EntityStatusWrapper statusWrapper;
        if (Objects.equals(eventType, this.itemsProperties.getResourceCreatedEventType()) && STATUS_APPROVED.equalsIgnoreCase((statusWrapper = (EntityStatusWrapper)CloudEventUtil.getObjectMapper().convertValue(eventData, EntityStatusWrapper.class)).getStatus()) && OPERATION_TYPE_CREATE.equalsIgnoreCase(statusWrapper.getAdditionalData().getOperationType())) {
            this.discussionService.createDiscussionFromEvent(id, eventData, ResourceType.ITEM.getValue());
        }
    }

    @Generated
    public CatalogItemStatusSubscriber(DiscussionService discussionService, ItemsProperties itemsProperties) {
        this.discussionService = discussionService;
        this.itemsProperties = itemsProperties;
    }
}

