/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer.impl;

import com.finconsgroup.itserr.marketplace.discussion.bs.config.properties.DiscussionBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer.ResourceProducer;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import com.finconsgroup.itserr.messaging.producer.MessageProducer;
import com.finconsgroup.itserr.messaging.producer.ProducerRegistry;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"messaging.enabled"}, havingValue="true")
public class DefaultResourceProducer
implements ResourceProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultResourceProducer.class);
    private final MessageProducer messageProducer;
    private final DiscussionBsConfigurationProperties.MessagingProperties messagingProperties;

    public DefaultResourceProducer(DiscussionBsConfigurationProperties bsConfigurationProperties, ProducerRegistry producerRegistry) {
        this.messagingProperties = bsConfigurationProperties.getMessaging();
        this.messageProducer = producerRegistry.getMessageProducer(this.messagingProperties.getProducerName());
    }

    public void publishCreatedResource(@NotNull DiscussionDTO resource) {
        this.publish(resource, this.messagingProperties.getResourceCreatedType());
    }

    public void publishUpdatedResource(@NotNull DiscussionDTO resource) {
        this.publish(resource, this.messagingProperties.getResourceUpdatedType());
    }

    public void publishDeletedResource(@NotNull DiscussionDTO resource) {
        this.publish(resource, this.messagingProperties.getResourceDeletedType());
    }

    private void publish(@NonNull DiscussionDTO resource, @NonNull String eventType) {
        try {
            Map<String, DiscussionDTO> messageMap = Map.of(resource.getId().toString(), resource);
            Map<String, String> filterProperties = Map.of("service", "discussion");
            log.debug("Sending message, messageMap: {}, eventType: {}, source: {}, filterProperties: {}", new Object[]{messageMap, eventType, this.messagingProperties.getSource(), filterProperties});
            this.messageProducer.publishEvent(messageMap, eventType, this.messagingProperties.getSource(), filterProperties);
            log.info("Successfully published message for resource with id: {}", (Object)resource.getId());
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while sending message: %s".formatted(e.getMessage());
            throw new WP2MessagingException(errorMessage);
        }
    }
}

