/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.discussion.bs.bean.DiscussionApplicationEvent;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.MessagingEventType;
import com.finconsgroup.itserr.marketplace.discussion.bs.service.AdminService;
import com.finconsgroup.itserr.marketplace.discussion.bs.service.DiscussionService;
import jakarta.annotation.PreDestroy;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class DefaultAdminService
implements AdminService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAdminService.class);
    private final DiscussionService discussionService;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ExecutorService executor;

    public DefaultAdminService(DiscussionService discussionService, ApplicationEventPublisher applicationEventPublisher) {
        this.discussionService = discussionService;
        this.applicationEventPublisher = applicationEventPublisher;
        this.executor = Executors.newVirtualThreadPerTaskExecutor();
    }

    public void publishAllMessages(String resourceType, String visibility, Instant createdAfter) {
        this.executor.submit(() -> this.publishAllMessagesAsync(resourceType, visibility, createdAfter));
    }

    @PreDestroy
    void close() {
        this.executor.shutdown();
    }

    private void publishAllMessagesAsync(String resourceType, String visibility, Instant createdAfter) {
        Page discussionsPage;
        int pageNumber = 0;
        long fetchedCount = 0L;
        while (!(discussionsPage = this.discussionService.getDiscussions(pageNumber, 50, "id", SortDirection.ASC.name(), visibility, false, resourceType, createdAfter)).getContent().isEmpty()) {
            discussionsPage.getContent().forEach(discussionDTO -> this.applicationEventPublisher.publishEvent((ApplicationEvent)new DiscussionApplicationEvent(discussionDTO, MessagingEventType.UPDATED)));
            long totalCount = discussionsPage.getTotalElements();
            log.info("Published {}/{} discussions", (Object)(fetchedCount += (long)discussionsPage.getContent().size()), (Object)discussionsPage.getTotalElements());
            if (totalCount <= fetchedCount) break;
            ++pageNumber;
        }
    }
}

