package com.finconsgroup.itserr.marketplace.discussion.dm.mapper;

import com.finconsgroup.itserr.marketplace.discussion.dm.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Thread;
import com.finconsgroup.itserr.marketplace.discussion.dm.enums.ReactionType;
import com.finconsgroup.itserr.marketplace.discussion.dm.repository.ThreadReactionRepository;
import org.mapstruct.*;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Mapper(componentModel = "spring")
public abstract class ThreadMapper {

    protected ThreadReactionRepository threadReactionRepository;

    @Autowired
    public void setThreadReactionRepository(ThreadReactionRepository threadReactionRepository) {
        this.threadReactionRepository = threadReactionRepository;
    }

    @Mapping(target = "parentId", source = "parent.id")
    @Mapping(target = "reactionCounts", ignore = true)
    public abstract ThreadDTO toDTO(Thread thread);

    @AfterMapping
    protected void afterToDTO(Thread thread, @MappingTarget ThreadDTO dto) {
        if (thread == null || dto == null) return;
        dto.setReactionCounts(calculateThreadReactionCounts(thread));
    }

    @Mapping(target = "discussion", ignore = true)
    @Mapping(target = "parent", ignore = true)
    @Mapping(target = "replies", ignore = true)
    @Mapping(target = "reactions", ignore = true)
    public abstract Thread toEntity(ThreadDTO dto);

    protected List<ThreadDTO> mapThreadRepliesToDTO(List<Thread> replies) {
        if (replies == null) return null;
        return replies.stream().map(this::toDTO).collect(Collectors.toList());
    }

    protected Map<ReactionType, Long> calculateThreadReactionCounts(Thread thread) {
        var results = threadReactionRepository.countByThreadGroupByReactionType(thread);
        Map<ReactionType, Long> reactionCounts = new HashMap<>();
        if (results != null) {
            for (var r : results) {
                reactionCounts.put(r.getReaction(), r.getCount());
            }
        }
        return reactionCounts;
    }
}
