/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.dm.entity;

import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Discussion;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Thread;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.ThreadReaction;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="threads")
public class Thread {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="discussion_id", nullable=false)
    private Discussion discussion;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_id")
    private Thread parent;
    @OneToMany(mappedBy="parent", cascade={CascadeType.ALL})
    private List<Thread> replies;
    private String createdBy;
    private Instant createdAt;
    @Column(name="modified_at")
    private Instant modifiedAt;
    @Column(columnDefinition="TEXT")
    private String content;
    @OneToMany(mappedBy="thread", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ThreadReaction> reactions;

    @PrePersist
    public void onCreate() {
        this.createdAt = Instant.now();
    }

    @Generated
    public static ThreadBuilder builder() {
        return new ThreadBuilder();
    }

    @Generated
    public Thread() {
    }

    @Generated
    public Thread(UUID id, Discussion discussion, Thread parent, List<Thread> replies, String createdBy, Instant createdAt, Instant modifiedAt, String content, List<ThreadReaction> reactions) {
        this.id = id;
        this.discussion = discussion;
        this.parent = parent;
        this.replies = replies;
        this.createdBy = createdBy;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.content = content;
        this.reactions = reactions;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public Discussion getDiscussion() {
        return this.discussion;
    }

    @Generated
    public Thread getParent() {
        return this.parent;
    }

    @Generated
    public List<Thread> getReplies() {
        return this.replies;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Instant getModifiedAt() {
        return this.modifiedAt;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public List<ThreadReaction> getReactions() {
        return this.reactions;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setDiscussion(Discussion discussion) {
        this.discussion = discussion;
    }

    @Generated
    public void setParent(Thread parent) {
        this.parent = parent;
    }

    @Generated
    public void setReplies(List<Thread> replies) {
        this.replies = replies;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setModifiedAt(Instant modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setReactions(List<ThreadReaction> reactions) {
        this.reactions = reactions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Thread)) {
            return false;
        }
        Thread other = (Thread)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Discussion this$discussion = this.getDiscussion();
        Discussion other$discussion = other.getDiscussion();
        if (this$discussion == null ? other$discussion != null : !this$discussion.equals(other$discussion)) {
            return false;
        }
        Thread this$parent = this.getParent();
        Thread other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        List this$replies = this.getReplies();
        List other$replies = other.getReplies();
        if (this$replies == null ? other$replies != null : !((Object)this$replies).equals(other$replies)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$modifiedAt = this.getModifiedAt();
        Instant other$modifiedAt = other.getModifiedAt();
        if (this$modifiedAt == null ? other$modifiedAt != null : !((Object)this$modifiedAt).equals(other$modifiedAt)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List this$reactions = this.getReactions();
        List other$reactions = other.getReactions();
        return !(this$reactions == null ? other$reactions != null : !((Object)this$reactions).equals(other$reactions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Thread;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Discussion $discussion = this.getDiscussion();
        result = result * 59 + ($discussion == null ? 43 : $discussion.hashCode());
        Thread $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        List $replies = this.getReplies();
        result = result * 59 + ($replies == null ? 43 : ((Object)$replies).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $modifiedAt = this.getModifiedAt();
        result = result * 59 + ($modifiedAt == null ? 43 : ((Object)$modifiedAt).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List $reactions = this.getReactions();
        result = result * 59 + ($reactions == null ? 43 : ((Object)$reactions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Thread(id=" + String.valueOf(this.getId()) + ", discussion=" + String.valueOf(this.getDiscussion()) + ", parent=" + String.valueOf(this.getParent()) + ", replies=" + String.valueOf(this.getReplies()) + ", createdBy=" + this.getCreatedBy() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", modifiedAt=" + String.valueOf(this.getModifiedAt()) + ", content=" + this.getContent() + ", reactions=" + String.valueOf(this.getReactions()) + ")";
    }
}

