package com.finconsgroup.itserr.marketplace.event.bs.configuration.properties;

import lombok.Builder;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.finconsgroup.itserr.marketplace.event.bs.configuration.properties.EventBsProperties.PROPERTY_PREFIX;

/**
 * It contains configuration for event business service management.
 *
 * @param imagesFolderName The folder name in the user's workspace to store image for events.
 */
@ConfigurationProperties(prefix = PROPERTY_PREFIX)
@Builder
public record EventBsProperties(String imagesFolderName) {
    public static final String PROPERTY_PREFIX = "event.bs";
}