package com.finconsgroup.itserr.marketplace.event.bs.mapper;

import com.finconsgroup.itserr.marketplace.event.bs.client.dto.userprofile.OutputUserProfileDmDto;
import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputSubscribedParticipantDto;
import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.event.bs.messaging.dto.EventMessagingAdditionalDataDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(config = MapperConfiguration.class)
public interface EventMapper {

    @Mapping(target = "eventPlanner", ignore = true)
    @Mapping(target = "maintainer", ignore = true)
    OutputEventDto eventDmDtoToBsDto(com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventDto outputEventDmDto);


    @Mapping(target = "id", source = "outputSubscribedParticipantDto.id")
    OutputSubscribedParticipantDto subscribedParticipantDmDtoToBsDto(
            com.finconsgroup.itserr.marketplace.event.dm.dto.OutputSubscribedParticipantDto outputSubscribedParticipantDto,
            OutputUserProfileDmDto outputUserProfileDmDto);

    OutputUserProfileDto userProfileDmDtoToBsDto(OutputUserProfileDmDto outputUserProfileDmDto);

    /**
     * Converts a {@link OutputEventDto} into a {@link MessagingEventDto}.
     *
     * @param outputEventDto event.
     * @return Created messaging event DTO.
     */
    @Mapping(target = "name", ignore = true)
    @Mapping(target = "status", ignore = true)
    @Mapping(target = "category", source = "outputEventDto.eventType")
    @Mapping(target = "timestamp", ignore = true)
    @Mapping(target = "user", ignore = true)
    @Mapping(target = "message", ignore = true)
    @Mapping(target = "additionalData", ignore = true)
    MessagingEventDto<EventMessagingAdditionalDataDto> toMessagingEventDto(OutputEventDto outputEventDto);

}
