/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.dto.PageRequestDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.event.bs.bean.EventApplicationEvent;
import com.finconsgroup.itserr.marketplace.event.bs.bean.EventSubscriptionApplicationEvent;
import com.finconsgroup.itserr.marketplace.event.bs.client.InstitutionalPageDmClient;
import com.finconsgroup.itserr.marketplace.event.bs.client.UserProfileDmClient;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.institutionalpage.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.institutionalpage.InputSearchPublishedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.institutionalpage.InstitutionalPageView;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.institutionalpage.OutputInstitutionalPageDmDto;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.userprofile.InputFindUserProfilesByIdsDto;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.userprofile.OutputUserProfileDmDto;
import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputSubscribedParticipantDto;
import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.event.bs.enums.MessagingEventType;
import com.finconsgroup.itserr.marketplace.event.bs.mapper.EventMapper;
import com.finconsgroup.itserr.marketplace.event.bs.service.EventService;
import com.finconsgroup.itserr.marketplace.event.dm.client.EventDmClient;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputCreateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputProgramSubscribedParticipantDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputUpdateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputInstitutionalPageDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class DefaultEventService
implements EventService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEventService.class);
    private final EventDmClient eventDmClient;
    private final EventMapper eventMapper;
    private final UserProfileDmClient userProfileDmClient;
    private final InstitutionalPageDmClient institutionalPageDmClient;
    private final ApplicationEventPublisher applicationEventPublisher;

    @NonNull
    public OutputPageDto<com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto> findAll(Set<String> associationsToLoad, @NonNull PageRequestDto pageRequest) {
        OutputPageDto outputEventPageDmDto = this.eventDmClient.findAll(associationsToLoad, pageRequest.getPageNumber(), pageRequest.getPageSize(), pageRequest.getSort(), pageRequest.getDirection());
        return OutputPageDto.builder().content(this.mapEventDmDtoListToEventBsDtoList(outputEventPageDmDto.getContent())).page(outputEventPageDmDto.getPage()).build();
    }

    @NonNull
    public com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto findById(@NonNull UUID eventId) {
        OutputEventDto outputEventDmDto = this.eventDmClient.findById(eventId);
        return (com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto)this.mapEventDmDtoListToEventBsDtoList(List.of(outputEventDmDto)).getFirst();
    }

    @NonNull
    public com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto create(@NonNull com.finconsgroup.itserr.marketplace.event.bs.dto.InputCreateEventDto inputCreateEventDto) {
        OutputEventDto outputEventDmDto = this.eventDmClient.createEvent((InputCreateEventDto)inputCreateEventDto);
        com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto outputEventDto = (com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto)this.mapEventDmDtoListToEventBsDtoList(List.of(outputEventDmDto)).getFirst();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new EventApplicationEvent(outputEventDto, MessagingEventType.CREATED));
        return outputEventDto;
    }

    @NonNull
    public com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto updateById(@NonNull UUID eventId, @NonNull com.finconsgroup.itserr.marketplace.event.bs.dto.InputUpdateEventDto inputUpdateEventDto) {
        OutputEventDto outputEventDmDto = this.eventDmClient.updateEventById(eventId, (InputUpdateEventDto)inputUpdateEventDto);
        com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto outputEventDto = (com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto)this.mapEventDmDtoListToEventBsDtoList(List.of(outputEventDmDto)).getFirst();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new EventApplicationEvent(outputEventDto, MessagingEventType.UPDATED));
        return outputEventDto;
    }

    public void deleteById(@NonNull UUID eventId) {
        com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto outputEventDto = (com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto)this.mapEventDmDtoListToEventBsDtoList(List.of(this.eventDmClient.findById(eventId))).getFirst();
        this.eventDmClient.deleteEventById(eventId);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new EventApplicationEvent(outputEventDto, MessagingEventType.DELETED));
    }

    @NonNull
    public com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto register(@NonNull UUID eventId) {
        OutputEventDto outputEventDmDto = this.eventDmClient.register(eventId);
        com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto outputEventDto = (com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto)this.mapEventDmDtoListToEventBsDtoList(List.of(outputEventDmDto)).getFirst();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new EventSubscriptionApplicationEvent(outputEventDto, MessagingEventType.REGISTER));
        return outputEventDto;
    }

    @NonNull
    public com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto unregister(@NonNull UUID eventId) {
        OutputEventDto outputEventDmDto = this.eventDmClient.unregister(eventId);
        com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto outputEventDto = (com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto)this.mapEventDmDtoListToEventBsDtoList(List.of(outputEventDmDto)).getFirst();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new EventSubscriptionApplicationEvent(outputEventDto, MessagingEventType.UNREGISTER));
        return outputEventDto;
    }

    @NonNull
    public com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto registerProgram(@NonNull UUID eventId, @NonNull UUID programId, @NonNull com.finconsgroup.itserr.marketplace.event.bs.dto.InputProgramSubscribedParticipantDto inputProgramSubscribedParticipantDto) {
        OutputEventDto outputEventDmDto = this.eventDmClient.registerProgram(eventId, programId, (InputProgramSubscribedParticipantDto)inputProgramSubscribedParticipantDto);
        return (com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto)this.mapEventDmDtoListToEventBsDtoList(List.of(outputEventDmDto)).getFirst();
    }

    @NonNull
    public com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto unregisterProgram(@NonNull UUID eventId, @NonNull UUID programId) {
        OutputEventDto outputEventDmDto = this.eventDmClient.unregisterProgram(eventId, programId);
        return (com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto)this.mapEventDmDtoListToEventBsDtoList(List.of(outputEventDmDto)).getFirst();
    }

    @NonNull
    private List<com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto> mapEventDmDtoListToEventBsDtoList(List<OutputEventDto> outputEventDmDtoList) {
        HashSet institutionalPageIds = new HashSet();
        HashSet userProfileIds = new HashSet();
        outputEventDmDtoList.forEach(outputEventDto -> {
            institutionalPageIds.addAll(Optional.ofNullable(outputEventDto.getInstitutionalPages()).orElse(List.of()).stream().map(OutputInstitutionalPageDto::getId).toList());
            Optional.ofNullable(outputEventDto.getEventPlannerId()).ifPresent(userProfileIds::add);
            Optional.ofNullable(outputEventDto.getMaintainerId()).ifPresent(userProfileIds::add);
            if (outputEventDto.getSubscribedParticipants() != null) {
                outputEventDto.getSubscribedParticipants().stream().map(com.finconsgroup.itserr.marketplace.event.dm.dto.OutputSubscribedParticipantDto::getUserId).forEach(userProfileIds::add);
            }
        });
        Map userProfileDmDtoById = this.loadUserProfiles(userProfileIds);
        Map institutionalPageDmDtoById = this.loadInstitutionalPages(institutionalPageIds);
        return outputEventDmDtoList.stream().map(dto -> this.mapToOutputEventBsDto(dto, userProfileDmDtoById, institutionalPageDmDtoById)).collect(Collectors.toList());
    }

    private com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto mapToOutputEventBsDto(OutputEventDto outputEventDmDto, Map<UUID, OutputUserProfileDmDto> userProfileDmDtoById, Map<UUID, OutputInstitutionalPageDmDto> institutionalPageDmDtoById) {
        com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto outputEventDto = this.eventMapper.eventDmDtoToBsDto(outputEventDmDto);
        List<OutputInstitutionalPageDto> institutionalPages = Optional.ofNullable(outputEventDto.getInstitutionalPages()).orElse(List.of()).stream().map(institutionalPage -> {
            OutputInstitutionalPageDmDto institutionalPageDmDto = (OutputInstitutionalPageDmDto)institutionalPageDmDtoById.get(institutionalPage.getId());
            if (institutionalPageDmDto == null) {
                return institutionalPage;
            }
            return OutputInstitutionalPageDto.builder().id(institutionalPage.getId()).name(institutionalPageDmDto.getName()).build();
        }).toList();
        outputEventDto.setInstitutionalPages(institutionalPages);
        outputEventDto.setEventPlanner(this.mapToOutputUserProfileDmDto(outputEventDto.getEventPlannerId(), userProfileDmDtoById));
        outputEventDto.setMaintainer(this.mapToOutputUserProfileDmDto(outputEventDto.getMaintainerId(), userProfileDmDtoById));
        if (outputEventDto.getSubscribedParticipants() != null) {
            for (int i = 0; i < outputEventDto.getSubscribedParticipants().size(); ++i) {
                com.finconsgroup.itserr.marketplace.event.dm.dto.OutputSubscribedParticipantDto subscribedParticipantDmDto = (com.finconsgroup.itserr.marketplace.event.dm.dto.OutputSubscribedParticipantDto)outputEventDto.getSubscribedParticipants().get(i);
                OutputSubscribedParticipantDto outputSubscribedParticipantDto = this.eventMapper.subscribedParticipantDmDtoToBsDto(subscribedParticipantDmDto, userProfileDmDtoById.get(subscribedParticipantDmDto.getUserId()));
                outputEventDto.getSubscribedParticipants().set(i, outputSubscribedParticipantDto);
            }
        }
        return outputEventDto;
    }

    private OutputUserProfileDto mapToOutputUserProfileDmDto(UUID userProfileId, @NonNull Map<UUID, OutputUserProfileDmDto> userProfileDmDtoById) {
        if (userProfileId == null) {
            return null;
        }
        OutputUserProfileDmDto userProfileDmDto = userProfileDmDtoById.get(userProfileId);
        if (userProfileDmDto == null) {
            return OutputUserProfileDto.builder().id(userProfileId).build();
        }
        return this.eventMapper.userProfileDmDtoToBsDto(userProfileDmDto);
    }

    private Map<UUID, OutputUserProfileDmDto> loadUserProfiles(Set<UUID> userProfileIds) {
        if (userProfileIds.isEmpty()) {
            return Map.of();
        }
        HashMap<UUID, OutputUserProfileDmDto> userProfileDmDtoById = new HashMap<UUID, OutputUserProfileDmDto>();
        try {
            InputFindUserProfilesByIdsDto inputFindUserProfilesByIdsDto = InputFindUserProfilesByIdsDto.builder().ids(new ArrayList<UUID>(userProfileIds)).build();
            OutputPageDto userOutputProfileDmPageDto = this.userProfileDmClient.findAllByIds(inputFindUserProfilesByIdsDto, 0, userProfileIds.size(), "id", SortDirection.ASC);
            userOutputProfileDmPageDto.getContent().forEach(outputUserProfileDmDto -> userProfileDmDtoById.put(outputUserProfileDmDto.getId(), (OutputUserProfileDmDto)outputUserProfileDmDto));
        }
        catch (Exception e) {
            log.error("Error loading user profiles", (Throwable)e);
        }
        return userProfileDmDtoById;
    }

    private Map<UUID, OutputInstitutionalPageDmDto> loadInstitutionalPages(Set<UUID> institutionalPageIds) {
        HashMap<UUID, OutputInstitutionalPageDmDto> institutionalPageDmDtoById = new HashMap<UUID, OutputInstitutionalPageDmDto>(this.loadPublishedInstitutionalPages(institutionalPageIds));
        HashSet<UUID> remainingInstitutionalPageIds = new HashSet<UUID>(institutionalPageIds);
        if (!institutionalPageDmDtoById.isEmpty()) {
            remainingInstitutionalPageIds.removeAll(institutionalPageDmDtoById.keySet());
        }
        if (!remainingInstitutionalPageIds.isEmpty()) {
            institutionalPageDmDtoById.putAll(this.loadPrivateMemberInstitutionalPages(remainingInstitutionalPageIds));
        }
        return institutionalPageDmDtoById;
    }

    private Map<UUID, OutputInstitutionalPageDmDto> loadPublishedInstitutionalPages(Set<UUID> institutionalPageIds) {
        if (institutionalPageIds.isEmpty()) {
            return Map.of();
        }
        HashMap<UUID, OutputInstitutionalPageDmDto> institutionalPageDmDtoById = new HashMap<UUID, OutputInstitutionalPageDmDto>();
        try {
            InputSearchPublishedInstitutionalPageDto inputSearchInstitutionalPageDto = InputSearchPublishedInstitutionalPageDto.builder().ids(new ArrayList<UUID>(institutionalPageIds)).build();
            OutputPageDto institutionalPageDmPageDto = this.institutionalPageDmClient.searchPublishedInstitutionalPages(inputSearchInstitutionalPageDto, Set.of("none"), 0, institutionalPageIds.size(), "id", SortDirection.ASC);
            institutionalPageDmPageDto.getContent().forEach(outputInstitutionalPageDmDto -> institutionalPageDmDtoById.put(outputInstitutionalPageDmDto.getId(), (OutputInstitutionalPageDmDto)outputInstitutionalPageDmDto));
        }
        catch (Exception e) {
            log.error("Error loading published institutional pages", (Throwable)e);
        }
        return institutionalPageDmDtoById;
    }

    private Map<UUID, OutputInstitutionalPageDmDto> loadPrivateMemberInstitutionalPages(Set<UUID> institutionalPageIds) {
        if (institutionalPageIds.isEmpty() || JwtTokenHolder.getUserId().isEmpty()) {
            return Map.of();
        }
        HashMap<UUID, OutputInstitutionalPageDmDto> institutionalPageDmDtoById = new HashMap<UUID, OutputInstitutionalPageDmDto>();
        try {
            InputSearchForMemberInstitutionalPageDto inputSearchInstitutionalPageDto = InputSearchForMemberInstitutionalPageDto.builder().ids(new ArrayList<UUID>(institutionalPageIds)).includePrivateAndMember(Boolean.valueOf(true)).includePublishedAndMember(Boolean.valueOf(false)).includePublishedAndNotMember(Boolean.valueOf(false)).build();
            OutputPageDto institutionalPageDmPageDto = this.institutionalPageDmClient.search(InstitutionalPageView.APPROVED, inputSearchInstitutionalPageDto, Set.of("none"), 0, institutionalPageIds.size(), "id", SortDirection.ASC);
            institutionalPageDmPageDto.getContent().forEach(outputInstitutionalPageDmDto -> institutionalPageDmDtoById.put(outputInstitutionalPageDmDto.getId(), (OutputInstitutionalPageDmDto)outputInstitutionalPageDmDto));
        }
        catch (Exception e) {
            log.error("Error loading private member institutional pages", (Throwable)e);
        }
        return institutionalPageDmDtoById;
    }

    @Generated
    public DefaultEventService(EventDmClient eventDmClient, EventMapper eventMapper, UserProfileDmClient userProfileDmClient, InstitutionalPageDmClient institutionalPageDmClient, ApplicationEventPublisher applicationEventPublisher) {
        this.eventDmClient = eventDmClient;
        this.eventMapper = eventMapper;
        this.userProfileDmClient = userProfileDmClient;
        this.institutionalPageDmClient = institutionalPageDmClient;
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

