package com.finconsgroup.itserr.marketplace.event.bs.messaging.impl;


import com.finconsgroup.itserr.marketplace.event.bs.messaging.EventProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

/**
 * Local stub implementation of {@link EventProducer}.
 * <p>
 * This implementation does not send any real messages but logs the invocation for testing purposes.
 */
@Component
@ConditionalOnProperty(name = "messaging.enabled", havingValue = "false")
@Slf4j
public class LoggerEventProducer implements EventProducer {

    @Override
    public void publishCreateEvent(@NonNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - CREATED event for resource: {}", eventDto);
    }

    @Override
    public void publishUpdateEvent(@NonNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - UPDATED event for resource: {}", eventDto);
    }

    @Override
    public void publishDeleteEvent(@NonNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - DELETED event for resource: {}", eventDto);
    }

    @Override
    public void publishSubscriptionEvent(@NonNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - SUBSCRIBE event for resource: {}", eventDto);
    }

    @Override
    public void publishUnSubscriptionEvent(@NonNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - UN-SUBSCRIBE event for resource: {}", eventDto);
    }
}