package com.finconsgroup.itserr.marketplace.event.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.LocalTime;
import java.util.List;
import java.util.UUID;

/**
 * Output DTO for program of a schedule of an event.
 */
@Schema(name = "OutputProgramDto", description = "DTO for program")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class OutputProgramDto {

    @Schema(description = "Unique identifier of the program", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "The title of the program", example = "Java Webinar")
    private String title;

    @Schema(description = "The description of the program", example = "Webinar on java new and breaking changes")
    private String description;

    @Schema(description = "The link for the program", example = "https://meeting.example.com/testProgram123")
    private String programLink;

    @Schema(description = "The program conductors")
    @Valid
    @NotEmpty
    private List<OutputProgramConductorDto> programConductors;

    @Schema(description = "The place of the program", example = "Via Test Street, Floor 2, Room 1")
    private String place;

    @Schema(description = "The street details for map", example = "can be coordinates or actual value")
    private String street;

    @Schema(description = "The house number", example = "432b/a")
    private String houseNumber;

    @Schema(description = "The maximum number of participants allowed for the program", example = "22")
    private Integer maxParticipants;

    @Schema(description = "List of subscribed participants")
    private List<OutputProgramSubscribedParticipantDto> subscribedParticipants;

    @Schema(description = "The number of participants subscribed for the program", example = "10")
    private Integer subscribedParticipantsCount;

    @Schema(description = "The start time of the program", example = "10:30:00")
    private LocalTime startTime;

    @Schema(description = "The end time of the program", example = "15:30:00")
    private LocalTime endTime;
}
