package com.finconsgroup.itserr.marketplace.event.dm.repository;

import com.finconsgroup.itserr.marketplace.event.dm.entity.ScheduleEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.UUID;

/**
 * {@link ScheduleRepository} repository.
 */
@Repository
public interface ScheduleRepository extends JpaRepository<ScheduleEntity, UUID> {

    /**
     * Retrieves the schedules for provided event ids
     *
     * @param eventIds the unique identifier of the events to be retrieved
     * @return an {@link List} containing the matching {@link ScheduleEntity}s if found, or an empty {@link List} if no match exists
     */
    List<ScheduleEntity> findAllByEventIdIn(List<UUID> eventIds);

}
