package com.finconsgroup.itserr.marketplace.event.dm.entity.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * A JPA {@link AttributeConverter} converting a {@link List<UUID>} attribute into a new-line separated string.
 */
@Converter
public class UUIDListConverter implements AttributeConverter<List<UUID>, String> {

    private static final String SEPARATOR = "|";
    private static final String SEPARATOR_REGEX = "\\|";

    @Override
    public String convertToDatabaseColumn(List<UUID> attribute) {
        if (attribute == null || attribute.isEmpty()) {
            return null;
        }
        return attribute.stream().map(UUID::toString).collect(Collectors.joining(SEPARATOR));
    }

    @Override
    public List<UUID> convertToEntityAttribute(String dbData) {
        if (dbData == null || dbData.isEmpty()) {
            return new ArrayList<>();
        }
        return Arrays.stream(dbData.split(SEPARATOR_REGEX))
                .filter(s -> !s.isEmpty())
                .map(UUID::fromString)
                .collect(Collectors.toCollection(ArrayList::new));
    }
}
