/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favouritesearch.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.api.FavouriteSearchApi;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.InputCreateFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.OutputFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.enums.SearchContext;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.service.FavouriteSearchService;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FavouriteSearchController
implements FavouriteSearchApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FavouriteSearchController.class);
    private final FavouriteSearchService favouriteSearchService;

    public OutputFavouriteSearchDto create(InputCreateFavouriteSearchDto inputCreateFavouriteSearchDto) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.favouriteSearchService.create(userId, inputCreateFavouriteSearchDto);
    }

    public Page<OutputFavouriteSearchDto> findAll(SearchContext context, String searchText, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.favouriteSearchService.findAll(userId, context, searchText, (Pageable)pageable);
    }

    public OutputFavouriteSearchDto findById(UUID favouriteSearchId) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.favouriteSearchService.findById(userId, favouriteSearchId);
    }

    public void deleteById(UUID favouriteSearchId) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        this.favouriteSearchService.deleteById(userId, favouriteSearchId);
    }

    @Generated
    public FavouriteSearchController(FavouriteSearchService favouriteSearchService) {
        this.favouriteSearchService = favouriteSearchService;
    }
}

