/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favouritesearch.dm.service.impl;

import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.InputCreateFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.OutputFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.entity.ArchivedFavouriteSearchEntity;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.entity.FavouriteSearchEntity;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.enums.SearchContext;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.exception.FavouriteSearchNotFoundException;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.mapper.ArchivedEntityMapper;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.mapper.FavouriteSearchMapper;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.repository.ArchivedFavouriteSearchRepository;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.repository.FavouriteSearchRepository;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.service.FavouriteSearchService;
import io.micrometer.common.util.StringUtils;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultFavouriteSearchService
implements FavouriteSearchService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultFavouriteSearchService.class);
    private final FavouriteSearchRepository favouriteSearchRepository;
    private final FavouriteSearchMapper favouriteSearchMapper;
    private final ArchivedFavouriteSearchRepository archivedFavouriteSearchRepository;
    private final ArchivedEntityMapper archivedEntityMapper;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputFavouriteSearchDto create(@NonNull UUID userId, @NonNull InputCreateFavouriteSearchDto inputCreateFavouriteSearchDto) {
        FavouriteSearchEntity favouriteSearchEntity = this.favouriteSearchMapper.toEntity(inputCreateFavouriteSearchDto, userId);
        FavouriteSearchEntity savedFavouriteSearchEntity = (FavouriteSearchEntity)this.favouriteSearchRepository.saveAndFlush((Object)favouriteSearchEntity);
        return this.favouriteSearchMapper.toDto(savedFavouriteSearchEntity);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputFavouriteSearchDto> findAll(@NonNull UUID userId, SearchContext context, @NonNull String searchText, @NonNull Pageable pageable) {
        boolean hasContext;
        boolean hasSearchText = StringUtils.isNotBlank((String)searchText);
        boolean bl = hasContext = context != null;
        Page favouriteSearchEntityPage = hasSearchText && hasContext ? this.favouriteSearchRepository.findAllByUserIdAndContextAndSearchTextContainingIgnoreCaseOrUserIdAndContextAndNameContainingIgnoreCase(userId, context, searchText, userId, context, searchText, pageable) : (hasSearchText ? this.favouriteSearchRepository.findAllByUserIdAndSearchTextContainingIgnoreCaseOrUserIdAndNameContainingIgnoreCase(userId, searchText, userId, searchText, pageable) : (hasContext ? this.favouriteSearchRepository.findByUserIdAndContext(userId, context, pageable) : this.favouriteSearchRepository.findAllByUserId(userId, pageable)));
        return favouriteSearchEntityPage.map(arg_0 -> ((FavouriteSearchMapper)this.favouriteSearchMapper).toDto(arg_0));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputFavouriteSearchDto findById(@NonNull UUID userId, @NonNull UUID favouriteSearchId) {
        return this.favouriteSearchRepository.findByUserIdAndId(userId, favouriteSearchId).map(arg_0 -> ((FavouriteSearchMapper)this.favouriteSearchMapper).toDto(arg_0)).orElseThrow(() -> new FavouriteSearchNotFoundException(favouriteSearchId));
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteById(@NonNull UUID userId, @NonNull UUID favouriteSearchId) {
        FavouriteSearchEntity favouriteSearchEntity = (FavouriteSearchEntity)this.favouriteSearchRepository.findByUserIdAndId(userId, favouriteSearchId).orElseThrow(() -> new FavouriteSearchNotFoundException(favouriteSearchId));
        this.persistArchivedCopy(favouriteSearchEntity);
        this.favouriteSearchRepository.delete((Object)favouriteSearchEntity);
    }

    private void persistArchivedCopy(FavouriteSearchEntity favouriteSearchEntity) {
        ArchivedFavouriteSearchEntity archivedFavouriteSearchEntity = this.archivedEntityMapper.toArchiveEntity(favouriteSearchEntity);
        this.archivedFavouriteSearchRepository.saveAndFlush((Object)archivedFavouriteSearchEntity);
    }

    @Generated
    public DefaultFavouriteSearchService(FavouriteSearchRepository favouriteSearchRepository, FavouriteSearchMapper favouriteSearchMapper, ArchivedFavouriteSearchRepository archivedFavouriteSearchRepository, ArchivedEntityMapper archivedEntityMapper) {
        this.favouriteSearchRepository = favouriteSearchRepository;
        this.favouriteSearchMapper = favouriteSearchMapper;
        this.archivedFavouriteSearchRepository = archivedFavouriteSearchRepository;
        this.archivedEntityMapper = archivedEntityMapper;
    }
}

