package com.finconsgroup.itserr.marketplace.favourite.user.bs.client;


import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.institutionalpage.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.institutionalpage.ModerationStatusInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.institutionalpage.OutputInstitutionalPageFavouriteDto;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Set;

/**
 * Feign Client interface for Institutional Pages Business Service
 */
public interface InstitutionalPageBsClient {

    /**
     * Retrieves a paginated list of all InstitutionalPages the user is contributing to, matching the search criteria.
     *
     * @param moderationStatus                         the status filter to be applied (required).
     * @param inputSearchForMemberInstitutionalPageDto the dto containing the filters to be applied
     * @param associationsToLoad                       comma separated list of the associations to be returned (default is "all").
     * @param pageNumber                               the page number to retrieve (default is 0)
     * @param pageSize                                 the number of InstitutionalPages per page (default is 10)
     * @param sort                                     the field to sort by (default is "name")
     * @param direction                                the direction of sorting (default is ascending)
     * @return a page of {@link OutputInstitutionalPageFavouriteDto} and HTTP status 200 (OK)
     */
    @PostMapping(value = "/institutional-page/institutional-pages/search", consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE)
    OutputPageDto<OutputInstitutionalPageFavouriteDto> search(
            @RequestParam(name = "moderationStatus") ModerationStatusInstitutionalPageDto moderationStatus,
            @RequestBody InputSearchForMemberInstitutionalPageDto inputSearchForMemberInstitutionalPageDto,
            @RequestParam(name = "associationsToLoad") Set<String> associationsToLoad,
            @RequestParam(name = "pageNumber") int pageNumber,
            @RequestParam(name = "pageSize") int pageSize,
            @RequestParam(name = "sort") String sort,
            @RequestParam(name = "direction") SortDirection direction
    );

}
