package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.institutionalpage;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;

@Getter
public enum ModerationStatusInstitutionalPageDto {
    APPROVED("Approved"),
    PENDING("Pending"),
    REJECTED("Rejected"),
    DRAFT("Draft");

    private final String label;

    ModerationStatusInstitutionalPageDto(String label) {
        this.label = label;
    }

    @JsonValue
    public String getLabel() {
        return label;
    }

    /**
     * It maps the label to a {@link ModerationStatusInstitutionalPageDto} object
     *
     * @param label the label to map to enum
     * @return {@link ModerationStatusInstitutionalPageDto} instance if found
     * @throws IllegalArgumentException if no matching instance found
     */
    public static ModerationStatusInstitutionalPageDto ofLabel(String label) {
        for (ModerationStatusInstitutionalPageDto moderationStatus : ModerationStatusInstitutionalPageDto.values()) {
            if (moderationStatus.label.equalsIgnoreCase(label)) {
                return moderationStatus;
            }
        }

        throw new IllegalArgumentException("Unsupported value: " + label);
    }
}
