package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.institutionalpage;

import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.FavouriteUserItemDetail;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;
import org.springframework.lang.NonNull;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

/**
 * It represents the response for an Institutional Page favourite item.
 */
@SuperBuilder(toBuilder = true)
@Schema(
    title = "Institutional Page response DTO for favourite",
    description = "Represents the response for favourite Institutional Page"
)
@Data
@NoArgsConstructor
@EqualsAndHashCode(of = "id")
public class OutputInstitutionalPageFavouriteDto implements FavouriteUserItemDetail {

    @Schema(description = "ID of the institutional page", example = "11111111-aaaa-0000-0000-000000000000")
    private UUID id;

    @Schema(description = "The name of the institutional page", example = "Criterion")
    private String name;

    @Schema(description = "Profile of the WP leads of the institutional page")
    private List<OutputInstitutionalPageUserProfileDto> wpLeads;

    @Schema(
            description = "The category of the institutional page",
            allowableValues = {"tool", "project"},
            example = "project"
    )
    private String category;

    @Schema(
            description = "The abstract of the institutional page",
            example = "WP3, the Toolkit for Religious Studies (T-ReS), aims to improve the research experience."
    )
    private String abstractContent;

    @Schema(description = "The application version", example = "v1.3.0")
    private String applicationVersion;

    @Schema(description = "The moderation status of the institutional page", example = "Approved")
    private String moderationStatus;

    @Schema(description = "Publication time", example = "2025-05-26T14:19:46.606883Z")
    private Instant publicationTime;

    @Schema(description = "Indicates whether the institutional page is published", example = "true")
    private Boolean published;

    @Schema(description = "Profile of the maintainer of the institutional page")
    private OutputInstitutionalPageUserProfileDto maintainer;

    @Schema(description = "Profile of the person who last modified the institutional page")
    private OutputInstitutionalPageUserProfileDto lastModifiedBy;

    @Schema(description = "List of tags", example = "[\"aramaic\",\"english\",\"italian\"]")
    private List<String> tags;

    @Schema(description = "The image URL", example = "https://picsum.photos/200")
    private String imageUrl;

    @Schema(description = "Created At", example = "2025-05-26T14:19:46.606883Z")
    private Instant creationTime;

    @Schema(description = "Last Updated At", example = "2025-05-27T14:19:46.606883Z")
    private Instant updateTime;

    @NonNull
    @Override
    public String getItemId() {
        return id.toString();
    }
}
