package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.people;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * DTO for finding user profile info by provided token info.
 */
@Schema(name = "FindUserProfilesByTokenInfoDto", description = "DTO for finding user profile details by provided token info")
@Data
@Builder
@AllArgsConstructor
public class InputFindUserProfilesByTokenInfoDto {

    @NotEmpty
    @Schema(
        description = "Any token info of the user profiles to retrieve its details, can be userId, username or email",
        example ="[\"antonio.manganelli89674\", \"b4dd94e4-5df9-417c-b75c-0bd20cf118fa\", \"a.mendola@d4science.org\"]")
    List<String> tokenInfos;
}