package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.people;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;

/**
 * Output DTO representing a userprofile.
 */
@Schema(name = "OutputUserProfile", description = "DTO representing a userprofile in responses")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputUserProfileDto {

    @Schema(description = "Unique identifier of the user profile", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "First name of the user", example = "John")
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    private String lastName;

    @Schema(description = "preferred Username of the user", example = "john.doe.213213")
    private String preferredUsername;

    @Schema(description = "Link of the image of user", example = "https://imageLink")
    private String imageUrl;

    @Schema(description = "ORCID identifier of the user", example = "0000-0002-1825-0097")
    private String orcid;

    @Schema(description = "Short biography of the user", example = "Ricercatore Legge 210/10 a tempo indeterminato")
    private String shortBio;

    @Schema(description = "Organization affiliation", example = "Stanford University")
    private String organizationAffiliation;

    @Schema(description = "Scientific Disciplinary Sectors", example = "[\"INF/01\", \"ING-INF/05\"]")
    private List<String> ssd;

    @Schema(description = "Areas of Expertise")
    private List<OutputExpertiseDto> expertises;

    @Schema(description = "The creation time of the table record", example = "2025-04-06T10:15:30+01:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;

    @Schema(description = "The last update time of the table record", example = "2025-04-06T10:15:30+01:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime updateTime;

    @Schema(description = "User preferred language", example = "EN")
    @NotBlank
    private String language;

    @JsonIgnore
    @Setter(AccessLevel.NONE)
    private String name;

    @JsonIgnore
    public String getName() {
        if (StringUtils.isBlank(name)) {
            if (StringUtils.isBlank(lastName)) {
                name = firstName;
            } else if (StringUtils.isBlank(firstName)) {
                name = lastName;
            } else {
                name = firstName + " " + lastName;
            }
        }
        return name;
    }

}
