package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.search;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.constant.DateTimeFormats;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.AuthorDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.FavouriteUserItemDetail;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;
import org.springframework.lang.NonNull;

import java.time.Instant;
import java.time.LocalDate;
import java.util.List;

/**
 * It represents the response for a Catalog favourite item.
 */
@SuperBuilder
@Schema(
    title = "Catalog search document response DTO for favourite",
    description = "Represents the response for Catalog search document for favourite"
)
@Data
@NoArgsConstructor
@EqualsAndHashCode(of = "id")
public class OutputCatalogFavouriteDto implements FavouriteUserItemDetail {

    @Schema(
        description = "ID",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private String id;

    @Schema(
        description = "Title",
        example = "Test Title")
    private String title;

    @Schema(
        description = "Catalog Tags")
    private List<String> tags;

    @Schema(
        description = "Authors")
    private List<AuthorDto> authors;

    @Schema(
        description = "Language",
        example = "EN")
    private String language;

    @Schema(
        description = "Created Timestamp",
        example = "2025-03-31T09:29:20.428656Z")
    private Instant createdAt;

    @Schema(
        description = "Description",
        example = "Test abstract for the item")
    private String description;

    @Schema(
        description = "Catalog Item Type",
        example = "dataset")
    private OutputCatalogTypeDto type;

    @Schema(
        description = "Image URL",
        example = "http://localhost/test/image.png")
    private String imageUrl;

    @Schema(
        description = "Maintainer")
    private OutputCatalogUserProfileDto maintainer;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateTimeFormats.ISO_DATE)
    @Schema(
        description = "Date",
        example = "2025-03-31")
    private LocalDate publicationDate;

    @Schema(
        description = "DOI",
        example = "https://doi.org/10.1234%2Fabcdefg")
    private String doi;

    @NonNull
    @Override
    public String getItemId() {
        return id;
    }
}
