package com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging;

import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.ResourceByFolloweeMessageBodyDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.FavouriteItemMessageBodyDto;
import org.springframework.lang.NonNull;

/**
 * Message Producer responsible for publishing news-related resource messages
 */
public interface EventProducer {

    /**
     * Publishes a message indicating that a new favourite item has been created. The created favourite item details are encapsulated within the provided
     * {@code FavouriteItemCreatedMessageBodyDto}.
     *
     * @param favouriteItem the details of the created favouriteItem to be published, must not be {@code null}.
     */
    void publishFavouriteItemCreatedEvent(@NonNull FavouriteItemMessageBodyDto favouriteItem);

    /**
     * Publishes a message indicating that a favourite item has been updated. The updated favourite item details are encapsulated within the provided
     * {@code FavouriteItemMessageBodyDto}.
     *
     * @param favouriteItem the details of the updated FavouriteItem to be published, must not be {@code null}.
     */
    void publishFavouriteItemUpdatedEvent(@NonNull FavouriteItemMessageBodyDto favouriteItem);

    /**
     * Publishes a message indicating that a favourite item has been deleted. The deleted favourite item details are encapsulated within the provided
     * {@code FavouriteItemMessageBodyDto}.
     *
     * @param favouriteItem the details of the deleted favouriteItem to be published, must not be {@code null}.
     */
    void publishFavouriteItemDeletedEvent(@NonNull FavouriteItemMessageBodyDto favouriteItem);

    /**
     * Publishes a message indicating that a resource has been created by a followee i.e. user who has follower.
     * The created favourite item details are encapsulated within the provided
     * {@code ResourceByFolloweeMessageBodyDto}.
     *
     * @param resourceByFollowee the details of the created resource along with followers to be published, must not be {@code null}.
     */
    void publishResourceCreatedByFolloweeEvent(@NonNull ResourceByFolloweeMessageBodyDto resourceByFollowee);

}
