/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.config.FavouriteUserBsProperties;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.config.MessagingCatalogBsProperties;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.CatalogItemMessagingStatusAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemService;
import com.finconsgroup.itserr.messaging.consumer.CloudEventConsumer;
import com.finconsgroup.itserr.messaging.consumer.handler.CloudEventTypeHandler;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.UntypedMessagingEventDto;
import io.cloudevents.CloudEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="catalogEventConsumer")
public class CatalogEventConsumer
extends CloudEventConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CatalogEventConsumer.class);
    private static final String OPERATION_TYPE_CREATE = "create";
    private static final String STATUS_APPROVED = "approved";
    private final FavouriteUserItemService favouriteUserItemService;

    public CatalogEventConsumer(FavouriteUserBsProperties favouriteUserBsConfigurationProperties, FavouriteUserItemService favouriteUserItemService) {
        super(new CloudEventTypeHandler[0]);
        MessagingCatalogBsProperties messagingCatalogBsProperties = favouriteUserBsConfigurationProperties.messaging().getCatalogBs();
        this.addHandler(messagingCatalogBsProperties.getResourceDeletedEventType(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (arg_0, arg_1) -> this.handleResourceDeleted(arg_0, arg_1));
        this.addHandler(messagingCatalogBsProperties.getResourceStatusChangeEventType(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (arg_0, arg_1) -> this.handleResourceStatusChange(arg_0, arg_1));
        this.favouriteUserItemService = favouriteUserItemService;
    }

    private void handleResourceDeleted(UntypedMessagingEventDto eventPayload, CloudEvent cloudEvent) {
        this.favouriteUserItemService.deleteByContextAndItemId(ItemContext.CATALOG, null, eventPayload.getId(), eventPayload.getUser());
    }

    private void handleResourceStatusChange(MessagingEventDto<CatalogItemMessagingStatusAdditionalDataDto> eventPayload, CloudEvent cloudEvent) {
        CatalogItemMessagingStatusAdditionalDataDto data = (CatalogItemMessagingStatusAdditionalDataDto)eventPayload.getAdditionalData();
        if (STATUS_APPROVED.equalsIgnoreCase(eventPayload.getStatus()) && OPERATION_TYPE_CREATE.equalsIgnoreCase(data.getOperationType()) && data.getMaintainerId() != null) {
            this.favouriteUserItemService.publishResourceCreatedByFolloweeEvent(ItemContext.CATALOG.getId(), data.getMaintainerId().toString(), eventPayload);
        }
    }
}

