/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.config.FavouriteUserBsProperties;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.config.MessagingInstitutionalPageBsProperties;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.InstitutionalPageStatusChangeNotificationData;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemService;
import com.finconsgroup.itserr.messaging.consumer.CloudEventConsumer;
import com.finconsgroup.itserr.messaging.consumer.handler.CloudEventTypeHandler;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import io.cloudevents.CloudEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="institutionalPageEventConsumer")
public class InstitutionalPageEventConsumer
extends CloudEventConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstitutionalPageEventConsumer.class);
    private static final String OPERATION_TYPE_CREATE = "create";
    private static final String OPERATION_TYPE_DELETE = "delete";
    private final FavouriteUserItemService favouriteUserItemService;

    public InstitutionalPageEventConsumer(FavouriteUserBsProperties favouriteUserBsConfigurationProperties, FavouriteUserItemService favouriteUserItemService) {
        super(new CloudEventTypeHandler[0]);
        MessagingInstitutionalPageBsProperties messagingInstitutionalPageBsProperties = favouriteUserBsConfigurationProperties.messaging().getInstitutionalPageBs();
        this.addHandler(messagingInstitutionalPageBsProperties.getResourceStatusChangeEventType(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (arg_0, arg_1) -> this.handleResourceStatusChange(arg_0, arg_1));
        this.favouriteUserItemService = favouriteUserItemService;
    }

    private void handleResourceStatusChange(MessagingEventDto<InstitutionalPageStatusChangeNotificationData> eventPayload, CloudEvent cloudEvent) {
        InstitutionalPageStatusChangeNotificationData data = (InstitutionalPageStatusChangeNotificationData)eventPayload.getAdditionalData();
        if (OPERATION_TYPE_CREATE.equalsIgnoreCase(data.getOperationType()) && Boolean.TRUE.equals(data.getApproved()) && Boolean.TRUE.equals(data.getPublished()) && data.getMaintainer() != null) {
            this.favouriteUserItemService.publishResourceCreatedByFolloweeEvent(ItemContext.INSTITUTIONAL_PAGE.getId(), data.getMaintainer().toString(), eventPayload);
        }
        if (OPERATION_TYPE_DELETE.equalsIgnoreCase(data.getOperationType()) && Boolean.TRUE.equals(data.getApproved())) {
            this.favouriteUserItemService.deleteByContextAndItemId(ItemContext.INSTITUTIONAL_PAGE, null, eventPayload.getId(), eventPayload.getUser());
        }
    }
}

